Einblendung = {};

function Einblendung.prerequisitesPresent(specializations)
    return true;
end;
function Einblendung:load(xmlFile)

	self.setblends1Visibility = SpecializationUtil.callSpecializationsFunction("setblends1Visibility");
	self.setblends2Visibility = SpecializationUtil.callSpecializationsFunction("setblends2Visibility");
        self.setblends3Visibility = SpecializationUtil.callSpecializationsFunction("setblends3Visibility");
	
      self.blends1 = {};
	  local i = 0;
      while true do
          local key = string.format("vehicle.blends1.blend1(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.blends1, {node=node});
          end;
          i = i + 1;
      end;
      self.blends1Active = false;
      self.blends2 = {};
	  local i = 0;
      while true do
          local key = string.format("vehicle.blends2.blend2(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.blends2, {node=node});
          end;
          i = i + 1;
      end;
	  self.blends2Active = false;
      self.blends3 = {};
	  local i = 0;
      while true do
          local key = string.format("vehicle.blends3.blend3(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, false);
              table.insert(self.blends3, {node=node});
          end;
          i = i + 1;
      end;
	  self.blends3Active = false;
end;
function Einblendung:delete()
end;
function Einblendung:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setblends1Visibility(visibility, true);
	local visibility = streamReadBool(streamId);
	self:setblends2Visibility(visibility, true);
        local visibility = streamReadBool(streamId);
	self:setblends3Visibility(visibility, true);
end;

function Einblendung:writeStream(streamId, connection)
	streamWriteBool(streamId, self.blends1Active);
	streamWriteBool(streamId, self.blends2Active);
        streamWriteBool(streamId, self.blends3Active);
end;
function Einblendung:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Einblendung:keyEvent(unicode, sym, modifier, isDown)
end;
function Einblendung:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.Einblendung1) then
              self:setblends1Visibility(not self.blends1Active);
          end;
          if InputBinding.hasEvent(InputBinding.Einblendung2) then
              self:setblends2Visibility(not self.blends2Active);
          end;
          if InputBinding.hasEvent(InputBinding.Einblendung3) then
              self:setblends3Visibility(not self.blends3Active);
          end;
	end;
end;
function Einblendung:onLeave()
end;
function Einblendung:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("Einblendung1"),  InputBinding.Einblendung1);
	g_currentMission:addHelpButtonText(g_i18n:getText("Einblendung2"),  InputBinding.Einblendung2);
        g_currentMission:addHelpButtonText(g_i18n:getText("Einblendung3"),  InputBinding.Einblendung3);
end;
function Einblendung:setblends1Visibility(visibility, noEventSend)
      if visibility ~= self.blends1Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends1Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends1Event:new(self, visibility));
              end;
          end;
  
          self.blends1Active = visibility;
  
          for _, blend1 in pairs(self.blends1) do
             setVisibility(blend1.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend1Visibility ~= nil then
                 v.setblend1Visibility(self, visibility);
              end;
          end;
      end;
end;
function Einblendung:setblends2Visibility(visibility, noEventSend)
      if visibility ~= self.blends2Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends2Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends2Event:new(self, visibility));
              end;
          end;
  
          self.blends2Active = visibility;
  
          for _, blend2 in pairs(self.blends2) do
             setVisibility(blend2.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend2Visibility ~= nil then
                 v.setblend2Visibility(self, visibility);
              end;
          end;
      end;
end;
function Einblendung:setblends3Visibility(visibility, noEventSend)
      if visibility ~= self.blends3Active then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(Setblends3Event:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(Setblends3Event:new(self, visibility));
              end;
          end;
  
          self.blends3Active = visibility;
  
          for _, blend3 in pairs(self.blends3) do
             setVisibility(blend3.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setblend3Visibility ~= nil then
                 v.setblend3Visibility(self, visibility);
              end;
          end;
      end;
end;