Joskin_Fass = {};

function Joskin_Fass.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Joskin_Fass:load(xmlFile)
	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.saveMinRpm = 0;
	
	self.Zeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Zeiger#index"));	
	self.ZeigerMin =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMax"));	
	self.ZeigerMax =  Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Zeiger#rotationMin"));	
	self.ZeigerAchse = getXMLString(xmlFile, "vehicle.Zeiger#rotationAchse");
	self.XAchse = "x";
	self.YAchse = "y";
	self.ZAchse = "z";
	self.PositiveZahl = false;
	self.NegativeZahl = false;
	self.ZeigerRotationNew = 0;
	
	--[[
	self.sprayValves = {};

	if self.isClient then
		local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystem#file");
		if psFile ~= nil then
			local i=0;
			while true do
				local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
				local node = getXMLString(xmlFile, baseName.. "#index");
				if node == nil then
					break;
				end;
				node = Utils.indexToObject(self.components, node);
				if node ~= nil then
					local sprayValve = {};
					sprayValve.particleSystems = {};
					--Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, self.baseDirectory);
					Utils.loadStaticParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, self.baseDirectory);	
					table.insert(self.sprayValves, sprayValve);
				end;
				i = i+1;
			end;
		end;
	end;
	]]
end;


function Joskin_Fass:update(dt)
	local rx, ry, rz = getRotation(self.Zeiger)
	local unterschiedMinMax = self.ZeigerMax - self.ZeigerMin; 
	if unterschiedMinMax > 0 then
		self.PositiveZahl = true;
		self.NegativeZahl = false;		
	else
		self.NegativeZahl = true;
		self.PositiveZahl = false;
	end;	
	local fillLevelNew = self.fillLevel / self.capacity * 100;
	local fillLevelPerCent = math.floor(fillLevelNew)
	local RotationStep = unterschiedMinMax / 100; 
	local ZeigerRotation = fillLevelPerCent * RotationStep; 
	local ZeigerRotationRad = math.rad(ZeigerRotation); 
	if self.PositiveZahl == true and self.NegativeZahl == false then
		self.ZeigerRotationNew = ZeigerRotationRad * -1;
	elseif self.PositiveZahl == false and self.NegativeZahl == true then
		self.ZeigerRotationNew = ZeigerRotationRad * 1;	
	end;
	if self.ZeigerAchse == self.XAchse then
		setRotation(self.Zeiger, self.ZeigerRotationNew, ry, rz)
	elseif self.ZeigerAchse == self.YAchse then
		setRotation(self.Zeiger, rx, self.ZeigerRotationNew, rz)	
	elseif self.ZeigerAchse == self.ZAchse then
		setRotation(self.Zeiger, rx, ry, self.ZeigerRotationNew)	
	end;
	
	if self.isTurnedOn or self.isSprayerFilling then
		self:setVehicleRpmUp(dt, true);
	else
		self:setVehicleRpmUp(dt, false);
	end;
	
	if self:getIsActive() then
		if self.isTurnedOn == false and self:getIsActiveForSound() then
			if self.isSprayerFilling and not self.spraySoundEnabled then
				playSample(self.spraySound, 0, self.spraySoundVolume, 0);
				setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
				self.spraySoundEnabled = true;
			elseif self.isSprayerFilling == false then
				stopSample(self.spraySound);
				self.spraySoundEnabled = false;
			end;
		end;
	end;
end;

function Joskin_Fass:delete()
--[[
	for k,sprayValve in pairs(self.sprayValves) do
		Utils.deleteParticleSystem(sprayValve.particleSystems);
	end;
	]]
end;

function Joskin_Fass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Joskin_Fass:keyEvent(unicode, sym, modifier, isDown)
end;

function Joskin_Fass:draw()
end;

function Joskin_Fass:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, steerable in pairs(g_currentMission.steerables) do
		if steerable == attacherVehicle then
			self.saveMinRpm = attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = self.attacherVehicle;
			end;
		elseif steerable == attacherVehicle.attacherVehicle then
			self.saveMinRpm = attacherVehicle.attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = attacherVehicle.attacherVehicle;
			end;
		end;
	end;
end; 	

function Joskin_Fass:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function Joskin_Fass:onDeactivate()
	self:setVehicleRpmUp(nil, false);
end;

function Joskin_Fass:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicleCopy ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicleCopy.motor.minRpm = math.max(self.attacherVehicleCopy.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicleCopy.motor.minRpm = math.min(self.attacherVehicleCopy.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicleCopy.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicleCopy.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicleCopy.motor.minRpm);
			self.attacherVehicleCopy:setFuelFillLevel(self.attacherVehicleCopy.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

Utils.loadStaticParticleSystem = function(xmlFile, psTable, baseString, linkNode, defaultEmittingState, filename, baseDirectory)
	--
	-- Static Particle System
	--
	-- Author:  Heady | www.planet-ls.de
	-- Date: 30.04.2011
	--
	--
	
	local defaultLinkNode = linkNode;
		if type(linkNode) == "table" then
			defaultLinkNode = linkNode[1].node;
		end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(linkNode, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);

	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = filename;
	end;
	if psFile == nil then
		return;
	end;
	psFile = Utils.getFilename(psFile, baseDirectory);  
	local rootNode = loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system " .. psFile);
		return;
	end	
	
	link(linkNode, rootNode)	

	local posString = getXMLString(xmlFile, baseString .. "#position");
	if posString ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posString);
		setTranslation(rootNode, posX, posY, posZ);
	end;	
	local rotString = getXMLString(xmlFile, baseString .. "#rotation");
	if rotString ~= nil then
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotString);
		rotX = Utils.degToRad(rotX);
		rotY = Utils.degToRad(rotY);
		rotZ = Utils.degToRad(rotZ);
		setRotation(rootNode, rotX, rotY, rotZ);
	end;

	--for i = getNumOfChildren(rootNode) - 1, 0, -1 do
	for i=1, getNumOfChildren(rootNode) do
		local child = getChildAt(rootNode, i-1);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 and getClassName(geometry) == "ParticleSystem" then
				table.insert(psTable, {geometry = geometry, shape = child});
				if defaultEmittingState ~= nil then
					setEmittingState(geometry, defaultEmittingState);
				end;
			end;
		end;
	end;

	return rootNode;
end;
