--
--
local moddir = g_currentModDirectory;

Vibro = {};

function Vibro.prerequisitesPresent(specializations)
    return true;
end;


function Vibro:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;


function Vibro:load(xmlFile)
	self.printTable = Vibro.printTable;
	self.updateMesh = Vibro.updateMesh;
	
	
	self.su = {};
	
	--<meshes rootIdx="0>7" meshCount="6" />
	self.su.meshes = {};
	self.su.msh1Cnt = getXMLInt(xmlFile, "vehicle.Vibro#mesh1Count");
	self.su.root1Idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Vibro#mesh1RootIdx"));
	for i=1,self.su.msh1Cnt do 
		local msh = getChildAt(self.su.root1Idx, 0);
		if msh ~= nil then
			table.insert(self.su.meshes, msh);
			link( getRootNode(), msh );
			setTranslation( msh, 0, 0, 0 );
			setRotation( msh, 0, 0, 0 );		
		else
			print("[ERROR:Vibro] Wrong numbers of meshes!");
			break;
		end;
	end;
	self.su.msh2Cnt = getXMLInt(xmlFile, "vehicle.Vibro#mesh2Count");
	self.su.root2Idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Vibro#mesh2RootIdx"));
	for i=1,self.su.msh2Cnt do 
		local msh = getChildAt(self.su.root2Idx, 0);
		if msh ~= nil then
			table.insert(self.su.meshes, msh);
			link( getRootNode(), msh );
			setTranslation( msh, 0, 0, 0 );
			setRotation( msh, 0, 0, 0 );		
		else
			print("[ERROR:Vibro] Wrong numbers of meshes!");
			break;
		end;
	end;
	
	
	--###
	self.setFoldingDir = SpecializationUtil.callSpecializationsFunction("setFoldingDir");	
	self.setUnfold = true;
	self.isFold = false;
	self.isUnfold = true;



	self.foldParts = {};
	local r=0;
	while true do 
		local baseName = string.format("vehicle.Vibro.foldingParts.foldingPart(%d)", r);
		local part = {};
		part.animCharSet = 0;
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode"));
		if rootNode ~= nil then
			local animCharSet = getAnimCharacterSet(rootNode);
			if animCharSet ~= 0 then
				local clip = getAnimClipIndex(animCharSet, getXMLString(xmlFile, baseName.."#animationClip"));
				if clip >= 0 then
					local speed = getXMLFloat(xmlFile, baseName.."#speedScale");
					part.animCharSet = animCharSet;
					part.speed = speed;
					assignAnimTrackClip(part.animCharSet, 0, clip);
					setAnimTrackLoopState(part.animCharSet, 0, false);
					part.animDuration = getAnimClipDuration(part.animCharSet, clip);
					--setAnimTrackTime(part.animCharSet, 0, self.animTimeForDetach);
				else
					print("[ERROR:Vibro] clip for foldingPart " .. r .. " is "..tostring(clip));
				end
			else
				print("[ERROR:Vibro] animCharSet for foldingPart " .. r .. " is "..tostring(animCharSet));
			end
		else
			break;
		end
		
		part.cmpJnts = {};
		part.anchorAct = {};
		local nrJnts = getXMLInt(xmlFile, baseName.."#componentJointCount");
		local jntIds = Utils.getVectorNFromString( getXMLString(xmlFile, baseName.. "#componentJointIndex"), nrJnts );
		local anchorAct = Utils.getVectorNFromString( getXMLString(xmlFile, baseName.. "#anchorActor"), nrJnts );
		for i,j in pairs(jntIds) do
			local componentJoint = self.componentJoints[j];
			table.insert(part.cmpJnts, componentJoint);
			table.insert(part.anchorAct, anchorAct[i]);
		end;
		
		table.insert(self.foldParts, part);
		r = r + 1;
	end;
	
	
	--###	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	self.cuttingAreas = {}
	for i=1, numCuttingAreas do
		self.cuttingAreas[i] = {};
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.cuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.cuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
		self.cuttingAreas[i].foldMinLimit = 0;
		self.cuttingAreas[i].foldMaxLimit = 1;
	end;		
	
	self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
	self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));	

	
	local cultivatorSound = getXMLString(xmlFile, "vehicle.cultivatorSound#file");
	self.cultivatorSoundEnabled = false;
	if cultivatorSound ~= nil and cultivatorSound ~= "" then
		cultivatorSound = Utils.getFilename(cultivatorSound, self.baseDirectory);
		self.cultivatorSound = createSample("cultivatorSound");
		loadSample(self.cultivatorSound, cultivatorSound, false);
		self.cultivatorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#pitchOffset"), 0);
		self.cultivatorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cultivatorSound#volume"), 1.0);
		setSamplePitch(self.cultivatorSound, self.cultivatorSoundPitchOffset);
	end	
	
	self.cultivatorDirectionNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorDirectionNode#index")), self.components[1].node);
	self.cultivatorLimitToField = false;
	self.cultivatorForceLimitToField = true;
 
	self.groundParticleSystems = {};
	--[[
	local entry = {};
	entry.ps = {};
	Utils.loadParticleSystem(xmlFile, entry.ps, "vehicle.groundParticleSystem", self.components, false, nil, self.baseDirectory);
	if table.getn(entry.ps) > 0 then
		entry.isActive = false;
		table.insert(self.groundParticleSystems, entry);
	end ]]--
	local i=0;
	while true do
		local baseName = string.format("vehicle.groundParticleSystems.groundParticleSystem(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
		end;
		local entry = {};
		entry.ps = {};
		Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
		if table.getn(entry.ps) > 0 then
			entry.isActive = false;
			entry.cuttingArea = i+1;
			table.insert(self.groundParticleSystems, entry);
		end
		i = i+1;
	end;	
	
	
	--###
	self.vibro = {};
	self.vibro.msh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vibro.mesh#index"));
	
	self.vibro.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vibro.adapter#index"));
	local x,y,z = getTranslation(self.vibro.adapter);
	self.vibro.adapterPos = {x=x, y=y, z=z};
	
	self.vibro.jnts = {};
	local tmpRoot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vibro.jntsRoot#index"));
	self.vibro.jnts.root = tmpRoot;
	for i=1,9 do 
		local c = getChildAt(tmpRoot, i-1);	
		table.insert( self.vibro.jnts, c );
	end;
	
	self.vibro.ref = {};
	local ref1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vibro.jntsRef1#index"));
	local ref2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vibro.jntsRef2#index"));
	table.insert( self.vibro.ref, ref1 );
	table.insert( self.vibro.ref, ref2 );	
	
	self.vibro.refDist = 0;
	
	-- ! last !
	link( getRootNode(), self.vibro.msh );
	setTranslation( self.vibro.msh, 0, 0, 0 );
	setRotation( self.vibro.msh, 0, 0, 0 );	

	self.forceUpdates = 10;	
		
	--# cylinder sound
	self.cylinderedHydraulicSoundEnabled2 = false;	
	
end;

function Vibro:delete()
print("function Vibro:delete()");
	for i,j in pairs(self.su.meshes) do
		delete(j);
	end;
	if self.vibro.msh ~= nil then
		delete(self.vibro.msh);
	end;		
	delete(self.cultivatorSound);
	for i, ps in pairs(self.groundParticleSystems) do
		if ps.ps ~= nil then 
			Utils.deleteParticleSystem(ps.ps);	
		end;
	end;		
end;

function Vibro:readStream(streamId, connection)
--print("function Vibro:readStream(streamId, connection)");
	self.setUnfold = streamReadBool(streamId);
	self.isUnfold = streamReadBool(streamId);
	self.isFold = streamReadBool(streamId);
	for i,part in pairs(self.foldParts) do	
		local t = streamReadFloat32(streamId);
		part.timeToLoad = t;
		enableAnimTrack(part.animCharSet, 0);
		setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
		setAnimTrackTime(part.animCharSet, 0, t, true);
		disableAnimTrack(part.animCharSet, 0);
		for i,jnt in pairs(part.cmpJnts) do
			setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
		end;			
	end;
end;

function Vibro:writeStream(streamId, connection)	
--print("function Vibro:writeStream(streamId, connection)	");
	streamWriteBool(streamId, self.setUnfold);
	streamWriteBool(streamId, self.isUnfold);
	streamWriteBool(streamId, self.isFold);
	for i,part in pairs(self.foldParts) do				
		local animTime = getAnimTrackTime(part.animCharSet, 0);
		streamWriteFloat32(streamId, animTime);
	end;
end;


function Vibro:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.setUnfold = getXMLBool(xmlFile, key.."#setUnfold");
		self.isFold = getXMLBool(xmlFile, key.."#isFold");
		self.isUnfold = getXMLBool(xmlFile, key.."#isUnfold");
		for i,part in pairs(self.foldParts) do	
			local t = getXMLFloat(xmlFile, key.."#animTimePart"..i);
			part.timeToLoad = t;
			enableAnimTrack(part.animCharSet, 0);
			setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
			setAnimTrackTime(part.animCharSet, 0, t, true);
			disableAnimTrack(part.animCharSet, 0);
			for i,jnt in pairs(part.cmpJnts) do
				setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
			end;			
		end;
		self.loadPartTimes = true;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function Vibro:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';
	local mystring = ' setUnfold="'..tostring(self.setUnfold)..'" ';	
	mystring = mystring .. ' isFold="'..tostring(self.isFold)..'" isUnfold="'..tostring(self.isUnfold)..'" ';	
	attributes = attributes .. mystring;
	mystring = '';
	for i,part in pairs(self.foldParts) do				
		local animTime = getAnimTrackTime(part.animCharSet, 0);
		mystring = mystring .. ' animTimePart'..i..'="'..animTime..'"';
	end;
	attributes = attributes .. mystring;
    local node = nil;
	return attributes, node;
end;

function Vibro:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vibro:keyEvent(unicode, sym, modifier, isDown)
end;

function Vibro:update(dt)	

	--#
	local playCylSound = false;
	
	
	--
	--[[
	if self.loadPartTimes == true then
		for i,part in pairs(self.foldParts) do	
			enableAnimTrack(part.animCharSet, 0);
			setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
			setAnimTrackTime(part.animCharSet, 0, part.timeToLoad);
			disableAnimTrack(part.animCharSet, 0);
			if self.isServer then 
				for i,jnt in pairs(part.cmpJnts) do
					setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
				end;
			end;				
		end;	
		self.loadPartTimes = false;
	end; 
	]]--

	--
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicleCopy.attachedImplements) do
			if self.attacherVehicleCopy.attachedImplements[i].object == self then			
				local index = self.attacherVehicleCopy.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicleCopy.attacherJoints[index];	
				self.attacherVehicleJoint = joint;
				self.attacherVehicleJointIndex = index;
			end;
		end;
		self.doJointSearch = false;
	end;	
	
	if self.attacherVehicleJoint ~= nil then
		if self.isUnfold == true then
			--if self.attacherVehicleJoint.moveDown == true then 
			--	if self.attacherVehicleCopy.isTurnedOn == false then
			--		self.attacherVehicleCopy:setIsTurnedOn(true);
			--	end;
			--else
			--	if self.attacherVehicleCopy.isTurnedOn == true then
			--		self.attacherVehicleCopy:setIsTurnedOn(false);
			--	end;
			--end;
		else
			if self.attacherVehicleJoint.moveDown == true then 
				self.attacherVehicleCopy:setJointMoveDown(self.attacherVehicleJointIndex, false);
			end;
		end;
	end;

	--
	if self.attacherVehicleCopy ~= nil then
		if self.isUnfold == false then
			if self.attacherVehicleCopy.isTurnedOn == true then
				--print("turning off (2)");
				self.attacherVehicleCopy:setIsTurnedOn(false);
			end;	
		end;
		
		
		--link( attacherVehicle.toolsFillRef, self.vibro.adapter );
		--setTranslation(self.vibro.adapter, 0,0,0);		
		
		if self.attacherVehicleCopy.toolsFillRef ~= nil then
		
			local x,y,z = getWorldTranslation( self.attacherVehicleCopy.toolsFillRef );
			--local rx,ry,rz = getWorldRotation( self.attacherVehicleCopy.toolsFillRef );
			
			local lx,ly,lz = worldToLocal( getParent(self.vibro.adapter), x,y,z );
			
			local dx,dy,dz = localDirectionToWorld( self.attacherVehicleCopy.toolsFillRef, 0, 0, 1 );
			local ldx,ldy,ldz = worldDirectionToLocal( getParent(self.vibro.adapter), dx,dy,dz );
			
			setTranslation( self.vibro.adapter, lx,ly,lz );
			--setRotation( self.vibro.adapter, lrx,lry,lrz );
			setDirection( self.vibro.adapter, ldx,ldy,ldz, 0,1,0 );
			
		end;
		
	end;	

	if self:getIsActive() then
	
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then			
			if self.attacherVehicleJoint.moveDown == false then			
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					if self.attacherVehicleSteer ~= nil then
						while self.attacherVehicleSteer.attacherVehicle ~= nil do
							self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
						end;						
						if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then					
							self:setFoldingDir( not self.setUnfold );
						end;
					end;
				end;
			end;		
		end;
	
	end;

	
	if (self.setUnfold == false and self.isFold == false) or
		(self.setUnfold == true and self.isUnfold == false) then 

		if self.isClient then
			playCylSound = true;				
		end;
		
		self.isFold = false;
		self.isUnfold = false;	
	
		local chk = 0;
		for i,part in pairs(self.foldParts) do
			
			enableAnimTrack(part.animCharSet, 0);
			local animTime = getAnimTrackTime(part.animCharSet, 0);
			
			local speed = -part.speed;
			if self.setUnfold == false then
				speed = part.speed;
			end;			
			
			setAnimTrackSpeedScale(part.animCharSet, 0, speed);		
			
			if self.isServer then 
				for i,jnt in pairs(part.cmpJnts) do
					setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
				end;
			end;
			
			
			if self.setUnfold == false and animTime >= part.animDuration then
				chk = chk + 1;
				setAnimTrackTime(part.animCharSet, 0, part.animDuration);
				disableAnimTrack(part.animCharSet, 0);
				--print("disabled");
			elseif self.setUnfold == true and animTime <= 0 then
				chk = chk + 1;
				setAnimTrackTime(part.animCharSet, 0, 0.0);
				disableAnimTrack(part.animCharSet, 0);
				--print("disabled");
			end;

		end;
		
		if chk == 2 then
			if self.setUnfold then
				self.isUnfold = true;
			else
				self.isFold = true;
			end;
		end;
		
	end;

	
	--###
	if self.isClient then
		if self:getIsActive() then
			self:updateMesh();
		elseif self.forceUpdates > 0 then
			self:updateMesh();
			self.forceUpdates = self.forceUpdates - 1;
		end;
	end;	
	
		
	--###
	if self.isClient then
		
		if playCylSound == true and self.cylinderedHydraulicSoundEnabled2 == false and self:getIsActiveForSound() then
			playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
			self.cylinderedHydraulicSoundEnabled2 = true;
		else
			if playCylSound == false and self.cylinderedHydraulicSoundEnabled2 then 
				stopSample(self.cylinderedHydraulicSound);
				self.cylinderedHydraulicSoundEnabled2 = false;
			end;
		end;		
	end	

end;


function Vibro:updateTick()

	-- cultivator part
	if self.isUnfold == true and self.attacherVehicleCopy ~= nil and self.attacherVehicleJoint ~= nil then
	
		local hasGroundContact = false;
		if self.groundReferenceNode ~= nil then
			local x,y,z = getWorldTranslation(self.groundReferenceNode);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			if terrainHeight+self.groundReferenceThreshold >= y then
				hasGroundContact = true;
			end;
		end;

		local doGroundManipulation = (hasGroundContact and (not self.onlyActiveWhenLowered or self:isLowered(false)) );

		local foldAnimTime = self.foldAnimTime;
		if doGroundManipulation then
			if self.isServer then
			
				if self.attacherVehicleCopy.isTurnedOn == false and self.attacherVehicleJoint.moveDown == true then
					if self.attacherVehicleCopy:getIsTurnedOnAllowed(false) then
					--if self.attacherVehicleCopy.fillLevel > 0 then
						--print("turning on (1)");
						self.attacherVehicleCopy:setIsTurnedOn(true);			
					end;
				end;
			
				local cuttingAreasSend = {};
				for _, cuttingArea in pairs(self.cuttingAreas) do
					if self:getIsAreaActive(cuttingArea) then
						local x,_,z = getWorldTranslation(cuttingArea.start);
						if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
							local x1,_,z1 = getWorldTranslation(cuttingArea.width);
							local x2,_,z2 = getWorldTranslation(cuttingArea.height);
							table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
						else
							showFieldNotOwnedWarning = true;
						end
					end;
				end;
				if table.getn(cuttingAreasSend) > 0 then
					local limitToField = self.cultivatorLimitToField or self.cultivatorForceLimitToField;
					local limitGrassDestructionToField = false;
					if not g_currentMission:getHasPermission("createFields", self:getOwner()) then
						limitToField = true;
						limitGrassDestructionToField = true;
					end;

					local dx,dy,dz = localDirectionToWorld(self.cultivatorDirectionNode, 0, 0, 1);
					local angle = Utils.convertToDensityMapAngle(Utils.getYRotationFromDirection(dx, dz), g_currentMission.terrainDetailAngleMaxValue);

					local realArea = CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle);
					g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle));

					local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
					local sqm = realArea*pixelToSqm;
					local ha = sqm/10000;
					g_currentMission.missionStats.hectaresWorkedTotal = g_currentMission.missionStats.hectaresWorkedTotal + ha;
					g_currentMission.missionStats.hectaresWorkedSession = g_currentMission.missionStats.hectaresWorkedSession + ha;
					
					--if self.attacherVehicleCopy.isTurnedOn then
					--	SprayerAreaEvent.runLocally(cuttingAreasSend);
					--	g_server:broadcastEvent(SprayerAreaEvent:new(cuttingAreasSend));					
					--end;
					
				end;
			end;
		else
			if self.attacherVehicleCopy.isTurnedOn == true then
				--print("turning off (3)");
				self.attacherVehicleCopy:setIsTurnedOn(false);			
			end;
		end

		if self.isClient then
			for _,ps in pairs(self.groundParticleSystems) do
				local enabled = (doGroundManipulation and self.lastSpeed*3600 > 5)
				if enabled and ps.cuttingArea ~= nil and self.cuttingAreas[ps.cuttingArea] ~= nil then
					enabled = self:getIsAreaActive(self.cuttingAreas[ps.cuttingArea]);
				end
				if ps.isActive ~= enabled then
					ps.isActive = enabled;
					Utils.setEmittingState(ps.ps, ps.isActive);
				end
			end

			if self.cultivatorSound ~= nil then
				if doGroundManipulation and self.lastSpeed*3600 > 3 then
					if not self.cultivatorSoundEnabled and self:getIsActiveForSound() then
						playSample(self.cultivatorSound, 0, self.cultivatorSoundVolume, 0);
						self.cultivatorSoundEnabled = true;
					end;
				else
					if self.cultivatorSoundEnabled then
						stopSample(self.cultivatorSound);
						self.cultivatorSoundEnabled = false;
					end;
				end;
			end;	
			
			-- missing ?!
		end;
		
	else
	
		if self.isClient then
			for _,ps in pairs(self.groundParticleSystems) do
				if ps.isActive ~= false then
					ps.isActive = enabled;
					Utils.setEmittingState(ps.ps, ps.isActive);
				end
			end	
			if self.cultivatorSoundEnabled then
				stopSample(self.cultivatorSound);
				self.cultivatorSoundEnabled = false;
			end;			
		end;
		
	end;
	
end;


function Vibro:draw()
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then			
			if self.attacherVehicleJoint ~= nil then
				if self.attacherVehicleJoint.moveDown == false then			
					g_currentMission:addHelpButtonText( g_i18n:getText("VOGELSANG_FOLD"), InputBinding.IMPLEMENT_EXTRA2 );
				end;
			end;
		end;
	end;
end;


function Vibro:onAttach(attacherVehicle)
	self.doJointSearch = true;
	self.attacherVehicleCopy = attacherVehicle;
	if self.attacherVehicleCopy.isTurnedOn  == true then
		--print("turning off (4)");
		self.attacherVehicleCopy:setIsTurnedOn(false);
	end;
	self.attacherVehicleSteer = self.attacherVehicleCopy;
	while self.attacherVehicleSteer.attacherVehicle ~= nil do
		self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
	end;
	
	self.attacherVehicleCopy.cuttingAreasBackUp = self.attacherVehicleCopy.cuttingAreas;
	self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;
	
	--self.attacherVehicleCopy.sprayValvesBackUp = self.attacherVehicleCopy.sprayValves;
	--self.attacherVehicleCopy.sprayValves = self.sprayValves;
	
	--self.attacherVehicleCopy.origSprayValvesBackUp = self.attacherVehicleCopy.origSprayValves;
	--self.attacherVehicleCopy.origSprayValves = self.sprayValves;
	
	self.attacherVehicleCopy.pressureStateSprayValvesBackUp = self.attacherVehicleCopy.pressureStateSprayValves;
	self.attacherVehicleCopy.pressureStateSprayValves = self.pressureStateSprayValves;	

	if attacherVehicle.toolsFillRef ~= nil then
		if attacherVehicle.stdSprayer ~= nil then
			setVisibility(attacherVehicle.stdSprayer, false);
		end
		--
		--unlink(self.vibro.adapter);
		--link( attacherVehicle.toolsFillRef, self.vibro.adapter );
		setTranslation(self.vibro.adapter, 0,0,0);
		if attacherVehicle.stdSprayer ~= nil then
			setVisibility(attacherVehicle.stdSprayer, false);
		end		
	end;	
end;

function Vibro:onDetach()	
	self.doJointSearch = false;
	self.attacherVehicleJoint = nil;
	self.attacherVehicleSteer = nil;
	if self.attacherVehicleCopy ~= nil then
		
		if self.attacherVehicleCopy.isTurnedOn  == true then
			--print("turning off (6)");
			self.attacherVehicleCopy:setIsTurnedOn(false);
		end;		
		
		self.attacherVehicleCopy.cuttingAreas = self.attacherVehicleCopy.cuttingAreasBackUp;
		--self.attacherVehicleCopy.sprayValves = self.attacherVehicleCopy.sprayValvesBackUp;
		--self.attacherVehicleCopy.origSprayValves = self.attacherVehicleCopy.origSprayValvesBackUp;
		self.attacherVehicleCopy.pressureStateSprayValves = self.attacherVehicleCopy.pressureStateSprayValvesBackUp;		
		
		if self.attacherVehicleCopy.toolsFillRef ~= nil then
			if self.attacherVehicleCopy.stdSprayer ~= nil then
				setVisibility(self.attacherVehicleCopy.stdSprayer, true);
			end
			--unlink(self.vibro.adapter);
			--link( self.rootNode, self.vibro.adapter );
			setTranslation(self.vibro.adapter, self.vibro.adapterPos.x, self.vibro.adapterPos.y, self.vibro.adapterPos.z);
		end;		
		
	end;
	self.attacherVehicleCopy = nil;
	self.forceUpdates = 10;	
end;

function Vibro:setFoldingDir(state, noEventSend)
--print("function Vibro:setFoldingDir("..tostring(state)..", "..tostring(noEventSend));
	SetFoldingDirVibroEvent.sendEvent(self, state, noEventSend);
	self.setUnfold = state;
end;


function Vibro:setParking(state, noEventSend)
--print("function Vibro:setParking("..tostring(state)..", "..tostring(noEventSend));
	self.setPark = state;
end;


function Vibro:updateMesh()	
	
	--### catmull rom spline
	
	--local xc1,yc1,zc1 = getWorldTranslation(self.vibro.ref[1]); 
	--local xc2,yc2,zc2 = getWorldTranslation(self.vibro.ref[2]); 
	--local xc3,yc3,zc3 = getWorldTranslation(self.components[3].node); 

	
	--print("1: x/y/z "..tostring(xc1).."/"..tostring(yc1).."/"..tostring(zc1));
	--print("2: x/y/z "..tostring(xc2).."/"..tostring(yc2).."/"..tostring(zc2));
	
	local x1,y1,z1 = localToWorld( self.vibro.ref[1], 0,-3,0.7 );
	--local d1 	= {x=x1, y=y1, z=z1};
	local x2,y2,z2 = localToWorld( self.vibro.ref[1], 0,-0.1,0 );
	--local d2 	= {x=x2, y=y2, z=z2};
	local x3,y3,z3 = localToWorld( self.vibro.ref[2], 0,0, 0.01 );
	--local d3 	= {x=x, y=y, z=z};
	local x4,y4,z4 = localToWorld( self.vibro.ref[2], 0, 0, 0.3 );
	--local d4 	= {x=x, y=y, z=z};	
	
	local dist = Utils.vector3Length( x2-x3, y2-y3, z2-z3);
	--print("dist="..dist);
	if math.abs(self.vibro.refDist - dist) > 0.001 then
		--print("-");
		self.vibro.refDist = dist;
	
		--# 1)
		--local pts = {};
		--table.insert( pts, {x=d1.x,	y=d1.y, z=d1.z} );
		--table.insert( pts, {x=d2.x,	y=d2.y, z=d2.z} ); --xc1,	y=yc1,	z=zc1} ); 
		--table.insert( pts, {x=d3.x,	y=d3.y, z=d3.z} ); --xc2, 	y=yc2,	z=zc2} ); 
		--table.insert( pts, {x=d4.x, y=d4.y,	z=d4.z} );

		--local x,y,z = worldToLocal( self.jntsRef, d1.x,d1.y,d1.z );
		--setTranslation( self.jnts[1], x,y,z );	
		for i=1,9 do 
			local t = (i-1)/8;
			--local xc = 0.5 *((2 * pts[2].x) + (-pts[1].x + pts[3].x) * t + (2*pts[1].x - 5*pts[2].x + 4*pts[3].x - pts[4].x) * t^2 + (-pts[1].x + 3*pts[2].x - 3*pts[3].x + pts[4].x) * t^3);
			--local yc = 0.5 *((2 * pts[2].y) + (-pts[1].y + pts[3].y) * t + (2*pts[1].y - 5*pts[2].y + 4*pts[3].y - pts[4].y) * t^2 + (-pts[1].y + 3*pts[2].y - 3*pts[3].y + pts[4].y) * t^3);
			--local zc = 0.5 *((2 * pts[2].z) + (-pts[1].z + pts[3].z) * t + (2*pts[1].z - 5*pts[2].z + 4*pts[3].z - pts[4].z) * t^2 + (-pts[1].z + 3*pts[2].z - 3*pts[3].z + pts[4].z) * t^3);
			local xc = 0.5 *((2 * x2) + (-x1 + x3) * t + (2*x1 - 5*x2 + 4*x3 - x4) * t^2 + (-x1 + 3*x2 - 3*x3 + x4) * t^3);
			local yc = 0.5 *((2 * y2) + (-y1 + y3) * t + (2*y1 - 5*y2 + 4*y3 - y4) * t^2 + (-y1 + 3*y2 - 3*y3 + y4) * t^3);
			local zc = 0.5 *((2 * z2) + (-z1 + z3) * t + (2*z1 - 5*z2 + 4*z3 - z4) * t^2 + (-z1 + 3*z2 - 3*z3 + z4) * t^3);
			
			local x,y,z = worldToLocal( self.vibro.jnts.root, xc,yc,zc );
			setTranslation( self.vibro.jnts[i], x,y,z );		
			
			if Vehicle.debugRendering then
				drawDebugPoint( xc,yc,zc, 1,i/9,0,1 );
			end;
			
			--local t = (i)/8;
			--local xc2 = 0.5 *((2 * pts[2].x) + (-pts[1].x + pts[3].x) * t + (2*pts[1].x - 5*pts[2].x + 4*pts[3].x - pts[4].x) * t^2 + (-pts[1].x + 3*pts[2].x - 3*pts[3].x + pts[4].x) * t^3);
			--local yc2 = 0.5 *((2 * pts[2].y) + (-pts[1].y + pts[3].y) * t + (2*pts[1].y - 5*pts[2].y + 4*pts[3].y - pts[4].y) * t^2 + (-pts[1].y + 3*pts[2].y - 3*pts[3].y + pts[4].y) * t^3);
			--local zc2 = 0.5 *((2 * pts[2].z) + (-pts[1].z + pts[3].z) * t + (2*pts[1].z - 5*pts[2].z + 4*pts[3].z - pts[4].z) * t^2 + (-pts[1].z + 3*pts[2].z - 3*pts[3].z + pts[4].z) * t^3);		
			--drawDebugLine(xc,yc,zc, 1,(i-1)/9,0,  xc,yc,zc, 1,i/9,0);
		end
		
		--# 2)
		for i=1,8 do
			local bx,by,bz = getWorldTranslation(self.vibro.jnts[i+1]);
			local ax,ay,az = getWorldTranslation(self.vibro.jnts[i]);
			local dx,dy,dz = worldDirectionToLocal( self.vibro.jnts.root, bx-ax, by-ay, bz-az );
			setDirection( self.vibro.jnts[i], dx,dy,dz );		
		end
		local bx,by,bz = localToWorld( self.vibro.ref[2], 0,0,1 );
		local ax,ay,az = getWorldTranslation(self.vibro.jnts[9]);
		local dx,dy,dz = worldDirectionToLocal( self.vibro.jnts.root, bx-ax, by-ay, bz-az );
		setDirection( self.vibro.jnts[9], dx,dy,dz );	
	
	end;
	
end;

--
--
--
--
--
SetFoldingDirVibroEvent = {};
SetFoldingDirVibroEvent_mt = Class(SetFoldingDirVibroEvent, Event);

InitEventClass(SetFoldingDirVibroEvent, "SetFoldingDirVibroEvent");

function SetFoldingDirVibroEvent:emptyNew()
    local self = Event:new(SetFoldingDirVibroEvent_mt);
    self.className="SetFoldingDirVibroEvent";
    return self;
end;

function SetFoldingDirVibroEvent:new(vehicle, state)
    local self = SetFoldingDirVibroEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetFoldingDirVibroEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetFoldingDirVibroEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetFoldingDirVibroEvent:run(connection)
	self.vehicle:setFoldingDir(self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(SetFoldingDirVibroEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;


function SetFoldingDirVibroEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFoldingDirVibroEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFoldingDirVibroEvent:new(vehicle, state));
		end;
	end;
end;