--
--

local moddir = g_currentModDirectory;

PressureState = {};

function PressureState.prerequisitesPresent(specializations)
    return true;
end;


function PressureState:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;


function PressureState:load(xmlFile)
	self.printTable = PressureState.printTable;


	self.hasPressureStates = false;
	
	self.pressureStateMin = 1;
	self.pressureStateMax = 1;
	self.pressureState = self.pressureStateMax;

	
	local caCnt = Utils.getNoNil( getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 1 );
	local psCnt = Utils.getNoNil( getXMLInt(xmlFile, "vehicle.cuttingAreas#pressureStateCount"), 1 );
	
	self.pressureStateMax = psCnt;
	
	if self.pressureStateSprayValves == nil then
		self.pressureStateSprayValves = {};
	end;
	
	for i=1,caCnt do
		self.cuttingAreas[i].pressureStates = {};
		--local j=1;
		for j=1,psCnt do
			local lps = getXMLInt(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#litersPerSecond",i,j));
			if lps == nil then 
				break;
			end;
			
			local e={};
			e.lps = lps;
			e.startPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#startPos",i,j)), 3 );
			e.widthPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#widthPos",i,j)), 3 );
			e.heightPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#heightPos",i,j)), 3 );

			table.insert(self.cuttingAreas[i].pressureStates, e);
			self.hasPressureStates = true;
			
			if self.pressureStateSprayValves[j] == nil then
				self.pressureStateSprayValves[j] = {};
			end;
			--e.sprayValves = {};
			local node = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#node",i,j) ));
			if node ~= nil then
				local static = getXMLBool(xmlFile, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d#staticPS",i,j) );
				local sprayValve = {};
				sprayValve.particleSystems = {};
				if static then
					StaticParticleSystem.loadParticleSystem(xmlFile, sprayValve.particleSystems, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d",i,j), self.components, false, nil, moddir);					
				else
					Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, string.format("vehicle.cuttingAreas.cuttingArea%d.pressureState%d",i,j), self.components, false, nil, moddir);
				end;
				
				sprayValve.foldMinLimit = 0;
				sprayValve.foldMaxLimit = 1;
				table.insert(self.pressureStateSprayValves[j], sprayValve);
			end;

			j=j+1;
		end;
	end; 
	
	self.origSprayValves = self.sprayValves;
	
	self.pressureStateMaster = Utils.getNoNil( getXMLBool(xmlFile, "vehicle.pressureState#master"), true );

	self.setPressureState = SpecializationUtil.callSpecializationsFunction("setPressureState");
	if self.pressureStateMaster then
		self:setPressureState(self.pressureStateMax, true);
	end;
end;

function PressureState:delete()
	for i,sprayValves in pairs(self.pressureStateSprayValves) do
		for j,valve in pairs(sprayValves) do
			if valve.particleSystems ~= nil then
				local del = true;
				if self.sprayValves ~= nil then
					for k,v2 in pairs(self.sprayValves) do
						if v2.particleSystems == valve.particleSystems then
							del = false;
							break;
						end;
					end;
				end;
				if (self.pressureStateMaster and del) or not self.pressureStateMaster then
					Utils.deleteParticleSystem(valve.particleSystems);
					valve.del = true;
				else
				end;
			else
			end;		
		end;
	end;
end;

function PressureState:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	self.pressureState = getXMLInt(xmlFile, key.."#pressureState");
	self:setPressureState(self.pressureState, true);
    return BaseMission.VEHICLE_LOAD_OK;	
end;

function PressureState:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'pressureState="'..tostring(self.pressureState)..'"';
    return attributes, nil;
end;

function PressureState:readStream(streamId, connection)
	self.pressureState = streamReadInt32(streamId);
end;

function PressureState:writeStream(streamId, connection)	
	streamWriteInt32(streamId, self.pressureState);
	self:setPressureState(state, true);
end;

function PressureState:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PressureState:keyEvent(unicode, sym, modifier, isDown)
end;

function PressureState:update(dt)	
	if not self.hasPressureStates or not self.pressureStateMaster then 
		return;
	end;
	
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.PRESSURESTATE_UP) then --and self.pressureState ~= self.pressureStateMax then
				local state = math.min( self.pressureStateMax, self.pressureState + 1 );
				self:setPressureState(state);
			elseif InputBinding.hasEvent(InputBinding.PRESSURESTATE_DOWN) then --and self.pressureState ~= self.pressureStateMin then
				local state = math.max( self.pressureStateMin, self.pressureState - 1 );
				self:setPressureState(state);
			end
		end
	end
		
	
end;

function PressureState:draw()
	if self.pressureStateMax > 1 then
		if self:getIsActive() then
			if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then	
				g_currentMission:addHelpButtonText( g_i18n:getText("PRESSURESTATE_UP"), InputBinding.PRESSURESTATE_UP );	
				g_currentMission:addHelpButtonText( g_i18n:getText("PRESSURESTATE_DOWN"), InputBinding.PRESSURESTATE_DOWN );	
			end;
		end;
	end;
end;


function PressureState:onAttach(attacherVehicle)
	self.attVeh = attacherVehicle;
	
	if self.attVeh.hasPressureStates then
		self.attVeh.pressureStateMin_BU = self.attVeh.pressureStateMin;
		self.attVeh.pressureStateMax_BU = self.attVeh.pressureStateMax;
		self.attVeh.pressureStateMin = self.pressureStateMin;
		self.attVeh.pressureStateMax = self.pressureStateMax;
		self.attVeh:setPressureState( self.pressureStateMax, true );
	end;
	
end;

function PressureState:onDetach()	
	if self.attVeh ~= nil then
		if self.attVeh.hasPressureStates then
			self.attVeh.pressureStateMin = self.attVeh.pressureStateMin_BU;
			self.attVeh.pressureStateMax = self.attVeh.pressureStateMax_BU;
			self.attVeh:setPressureState( self.attVeh.pressureStateMax_BU, true );
		end;
	end;
	self.attVeh = nil;
end;


function PressureState:setPressureState(state, noEventSend)	
--print("function PressureState:setPressureState("..tostring(state)..", "..tostring(noEventSend));	
	SetPressureStateEvent.sendEvent(self, state, noEventSend);
	self.pressureState = state;
	local newLps = 0;

	local isTurnedOn = self.isTurnedOn;
	if isTurnedOn then
		self:setIsTurnedOn(false);
	end;

	self.sprayValves = {};
		
	for i,ca in pairs(self.cuttingAreas) do
		if ca.pressureStates[state] ~= nil then
			setTranslation( ca.start, ca.pressureStates[state].startPos[1], ca.pressureStates[state].startPos[2], ca.pressureStates[state].startPos[3] );
			setTranslation( ca.width, ca.pressureStates[state].widthPos[1], ca.pressureStates[state].widthPos[2], ca.pressureStates[state].widthPos[3] );
			setTranslation( ca.height, ca.pressureStates[state].heightPos[1], ca.pressureStates[state].heightPos[2], ca.pressureStates[state].heightPos[3] );
			newLps = newLps + ca.pressureStates[state].lps;
		end;
	end;
	
	if self.pressureStateSprayValves[state] ~= nil then
		self.sprayValves = self.pressureStateSprayValves[state];
	else
		self.sprayValves = self.origSprayValves;
	end;	
	
	if newLps ~= 0 then
		--self.fillLitersPerSecond = newLps;
		self.defaultSprayLitersPerSecond = newLps;
	end;

	if isTurnedOn then
		self:setIsTurnedOn(true);
	end;
		
end;

--
--
--
--
--
SetPressureStateEvent = {};
SetPressureStateEvent_mt = Class(SetPressureStateEvent, Event);

InitEventClass(SetPressureStateEvent, "SetPressureStateEvent");

function SetPressureStateEvent:emptyNew()
    local self = Event:new(SetPressureStateEvent_mt);
    self.className="SetPressureStateEvent";
    return self;
end;

function SetPressureStateEvent:new(vehicle, state)
    local self = SetPressureStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetPressureStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.state = streamReadInt32(streamId);
    self:run(connection);
end;

function SetPressureStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, self.state);
end;

function SetPressureStateEvent:run(connection)
	self.vehicle:setPressureState(self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(SetPressureStateEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;


function SetPressureStateEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPressureStateEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPressureStateEvent:new(vehicle, state));
		end;
	end;
end;
