--
-- BJR_CoverEdgePallet
--
-- @author  JoXXer
-- @date  	07/11/13
--
-- @history	v1.0 - Initial implementation
--
--

BJR_CoverEdgePallet = {};

function BJR_CoverEdgePallet.prerequisitesPresent(specializations)
    return true;
end;

function BJR_CoverEdgePallet:load(xmlFile)
	self.removeRoll = SpecializationUtil.callSpecializationsFunction("removeRoll");
	
	self.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.CoverEdgeRolls#checkString"), "BJR_CoverEdgePallet");
	
	self.coverEdgeRolls = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.CoverEdgeRolls.CoverEdgeRoll(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local coverEdgeRoll = {};
		coverEdgeRoll.node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		if coverEdgeRoll.node ~= nil then
			table.insert(self.coverEdgeRolls, coverEdgeRoll);
		end;
		i = i + 1;
	end;
	
	self.rollsLeft = table.getn(self.coverEdgeRolls);
	self.balerInRange = nil;
end;

function BJR_CoverEdgePallet:delete()
end;

function BJR_CoverEdgePallet:readStream(streamId, connection)
	local rollsLeft = streamReadInt8(streamId);
	self:removeRoll(rollsLeft, true);
end;

function BJR_CoverEdgePallet:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.rollsLeft);
end;

function BJR_CoverEdgePallet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_CoverEdgePallet:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_CoverEdgePallet:update(dt)
end;

function BJR_CoverEdgePallet:updateTick(dt)
	if self.isClient then
		if self.rollsLeft > 0 then
			for _,vehicle in pairs(g_currentMission.vehicles) do
				if vehicle.isVehicleSaved and vehicle.coverEdge ~= nil then
					if vehicle.coverEdge.checkString == self.checkString then 
						local sX, sY, sZ = getWorldTranslation(self.rootNode);
						local vX, vY, vZ = getWorldTranslation(vehicle.rootNode);
						local distance = Utils.vector2Length(sX - vX, sZ - vZ);
						
						if distance < 5.0 then
							if vehicle.coverEdge.palletInRange == nil then
								vehicle.coverEdge.palletInRange = self;
								self.balerInRange = vehicle;
							end;
						else
							if vehicle.coverEdge.palletInRange then
								vehicle.coverEdge.palletInRange = nil;
								self.balerInRange = nil;
							end;
						end;
					end;
				end;
			end;
		else
			if self.balerInRange ~= nil then
				self.balerInRange.palletInRange = nil;
				self.balerInRange = nil;
			end;
		end;
	end;
end;

function BJR_CoverEdgePallet:draw()
end;

function BJR_CoverEdgePallet:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local rollsLeft = Utils.getNoNil(getXMLInt(xmlFile, key .. "#rollsLeft"), self.rollsLeft);
	self:removeRoll(rollsLeft, true);

    return BaseMission.VEHICLE_LOAD_OK;
end;

function BJR_CoverEdgePallet:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'rollsLeft="' .. tostring(self.rollsLeft) ..'"';

    return attributes, nil;
end;

function BJR_CoverEdgePallet:removeRoll(rollsLeft, noEventSend)
	RemoveRollEvent.sendEvent(self, rollsLeft, noEventSend);
	
	self.rollsLeft = rollsLeft;
	
	for v, roll in pairs(self.coverEdgeRolls) do
		if v > self.rollsLeft then
			setVisibility(roll.node, false);
		end;
	end;
end;


-- Events

RemoveRollEvent = {};
RemoveRollEvent_mt = Class(RemoveRollEvent, Event);

InitEventClass(RemoveRollEvent, "RemoveRollEvent");

function RemoveRollEvent:emptyNew()
    local self = Event:new(RemoveRollEvent_mt);
    return self;
end;

function RemoveRollEvent:new(vehicle, rollsLeft)
    local self = RemoveRollEvent:emptyNew()
    self.vehicle = vehicle;
	self.rollsLeft = rollsLeft;
    return self;
end;

function RemoveRollEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.vehicle = networkGetObject(id);
	self.rollsLeft = streamReadInt8(streamId);
    self:run(connection);
end;

function RemoveRollEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.rollsLeft);
end;

function RemoveRollEvent:run(connection)
	self.vehicle:removeRoll(self.rollsLeft, true);
end;

function RemoveRollEvent.sendEvent(vehicle, rollsLeft, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RemoveRollEvent:new(vehicle, rollsLeft), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(RemoveRollEvent:new(vehicle, rollsLeft));
		end;
	end;
end;