--
-- self
-- Class for all self
--
-- @author  Mario
-- @date  25/04/10
--
-- Copyright (C) Mario

Monitorius = {};

function Monitorius.prerequisitesPresent(specializations)
    return true;
end;

function Monitorius:load(xmlFile)
	-- Monitor
	self.detachPosition = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakPanel#detachPosition"));
	self.controlPanel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleTrakPanel#index"));
end;

function Monitorius:keyEvent(unicode, sym, modifier, isDown)
end;


function Monitorius:update(dt)
end;

function Monitorius:updateTick(dt)
	if self.isClient and self:getIsActive() and getVisibility(self.controlPanel) then
	
		if BJR_BaleTrakPanel.attacherVehicleCopy ~= nil and BJR_BaleTrakPanel.attacherVehicleCopy.isMotorStarted then
end;

function Monitorius:draw()
end;

function Monitorius:onEnter()

end;

function Monitorius:onAttach(attacherVehicle)
	BJR_BaleTrakPanel.attacherVehicleCopy = attacherVehicle;
	if attacherVehicle.addControlPanel ~= nil then
		local wasSuccessful = attacherVehicle:addControlPanel(self);
	else
		setVisibility(self.controlPanel, false);
end;
end;

function Monitorius:onDetach()
	if BJR_BaleTrakPanel.attacherVehicleCopy.removeControlPanel ~= nil then
		local wasSuccessful = BJR_BaleTrakPanel.attacherVehicleCopy:removeControlPanel(self);
	else
		setVisibility(self.controlPanel, true);
end;

function Monitorius:onLeave()
end;

function Monitorius:mouseEvent(posX, posY, isDown, isUp, button)
end;