--
-- JD4850
-- Specialization for JD4850 mod
--
-- @author  XXXXX
-- @date  XXXXX
--

JD4850 = {};

function JD4850.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JD4850:load(xmlFile)
    --hornSoundFile = Utils.getFilename("horn.wav", self.baseDirectory);
    --self.hornSoundId = createSample("famerCarSound");
    --loadSample(self.hornSoundId, hornSoundFile, false);
    --self.hornPlaying = false;
        local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;

    self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;

    self.incrementRotation = true;
    self.exhaustCover = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.exhaustCover#index"));
    if self.exhaustCover ~= nil then
        self.exhaustRotationSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationSpeed"), 0);
	  self.exhaustRotationMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationMax"), 0);
	  self.exhaustRotationMin = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.exhaustCover#rotationMin"), 0);
	  self.currentRotation = self.exhaustRotationMin;
    end;

    local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTanknadel2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#index"));
    if rotationPartNodeTanknadel2 ~= nil then
        self.rotationPartTanknadel2 = {};
        self.rotationPartTanknadel2.node = rotationPartNodeTanknadel2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#minRot"));
        self.rotationPartTanknadel2.minRot = {};
        self.rotationPartTanknadel2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#maxRot"));
        self.rotationPartTanknadel2.maxRot = {};
        self.rotationPartTanknadel2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#rotTime"), 2)*1000;
        self.rotationPartTanknadel2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel2#touchRotLimit"), 10));
    end;

	self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;

	self.lowLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lowLightDisplay#index"));
	self.farLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.farLightDisplay#index"));
	self.workLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.workLightDisplay#index"));
	self.fuelWarningDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fuelWarningDisplay#index"));
	self.handbrakeDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakeDisplay#index"));
	self.barDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.barDisplay#index"));
	self.roundLightDisplay = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.roundLightDisplay#index"));

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

    self.numrpmdisplays = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rpmdisplays#count"), 0);
    self.rpmdisplays = {};
    for i=1, self.numrpmdisplays do
        local objname = string.format("vehicle.rpmdisplays.rpmdisplay" .. "%d", i);
	  self.rpmdisplays[i] = {};
        self.rpmdisplays[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
	  self.rpmdisplays[i].rpmMinValue = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rpmMinValue"), 1);
	  self.rpmdisplays[i].rpmMaxValue = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rpmMaxValue"), 1);
        setVisibility(self.rpmdisplays[i].rotNode, false);
    end;

	self.numrpmlightdisplays = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rpmlightdisplays#count"), 0);
    self.rpmlightdisplays = {};
    for i=1, self.numrpmlightdisplays do
        local objname = string.format("vehicle.rpmlightdisplays.rpmlightdisplay" .. "%d", i);
	  self.rpmlightdisplays[i] = {};
        self.rpmlightdisplays[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
	  self.rpmlightdisplays[i].rpmMinValue = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rpmMinValue"), 1);
	  self.rpmlightdisplays[i].rpmMaxValue = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rpmMaxValue"), 1);
        setVisibility(self.rpmlightdisplays[i].rotNode, false);
    end;


	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;

      self.numPlowWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.plowWheels#count"), 0);
    self.plowWheels = {};
    for i=1, self.numPlowWheels do
        local plowWheelnamei = string.format("vehicle.plowWheels.plowWheel" .. "%d", i);
        self.plowWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, plowWheelnamei .. "#index"));
        setVisibility(self.plowWheels[i], false);
    end;


    self.gearShifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter#index"));
    self.gearIndicator = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearIndicator#index"));

	self.frontleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontleuchten#count"),0);
    self.frontleuchtenKey = getXMLString(xmlFile, "vehicle.frontleuchten#key");
    self.frontleuchtenAn = false;
    self.frontleuchten = {};
    for i=1, self.frontleuchtenAnz do
        local objname = string.format("vehicle.frontleuchten.light" .. "%d",i);
        self.frontleuchten[i] = {};
        self.frontleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.frontleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.frontleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.frontleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.frontleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.frontleuchten[i].emit and self.frontleuchten[i].source ~= nil then
           setVisibility(self.frontleuchten[i].source, false);
        end;
    end;

	self.farleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farleuchten#count"),0);
    self.farleuchtenKey = getXMLString(xmlFile, "vehicle.farleuchten#key");
    self.farleuchtenAn = false;
    self.farleuchten = {};
    for i=1, self.farleuchtenAnz do
        local objname = string.format("vehicle.farleuchten.light" .. "%d",i);
        self.farleuchten[i] = {};
        self.farleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.farleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.farleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.farleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.farleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.farleuchten[i].emit and self.farleuchten[i].source ~= nil then
           setVisibility(self.farleuchten[i].source, false);
        end;
    end;

      self.leuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.leuchten#count"),0);
    self.leuchtenKey = getXMLString(xmlFile, "vehicle.leuchten#key");
    self.leuchtenAn = false;
    self.leuchten = {};
    for i=1, self.leuchtenAnz do
        local objname = string.format("vehicle.leuchten.light" .. "%d",i);
        self.leuchten[i] = {};
        self.leuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.leuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.leuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.leuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.leuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.leuchten[i].emit and self.leuchten[i].source ~= nil then
           setVisibility(self.leuchten[i].source, false);
        end;
    end;

	self.worklightsActive = false;
	self.fuelWarnlightsActive = false;
	self.twinWheelsActive= false;
    	self.plowWheelsActive= false;


end;

function JD4850:delete()
    --delete(self.hornSoundId);
end;

function JD4850:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD4850:keyEvent(unicode, sym, modifier, isDown)
      if isDown and sym == Input.KEY_end then 
		self.twinWheelsActive = not self.twinWheelsActive;
		self.plowWheelsActive = false;
   end;
   if isDown and sym == Input.KEY_y then 
		self.plowWheelsActive = not self.plowWheelsActive;
		self.twinWheelsActive = false;
   end;

   if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;

    if self.isEntered then
      if self.frontleuchtenKey ~= nil then
         if isDown and sym == Input[self.frontleuchtenKey] then
            if self.leuchtenAn == false and self.frontleuchtenAn == false and self.farleuchtenAn == false then
           		self.leuchtenAn = true;
			self.frontleuchtenAn = true;
		elseif self.frontleuchtenAn == true then
			self.frontleuchtenAn = false;
			self.farleuchtenAn = true;
		elseif self.farleuchtenAn == true then
			self.farleuchtenAn = false;
			self.leuchtenAn = false;
		end;
         end;
      end;
   end;

   if self.isEntered then
         for i=1, self.leuchtenAnz do
           setVisibility(self.leuchten[i].light, self.leuchtenAn);
         end;
    end;

   if self.isEntered then
         for i=1, self.frontleuchtenAnz do
           setVisibility(self.frontleuchten[i].light, self.frontleuchtenAn);
         end;
    end;

    if self.isEntered then
         for i=1, self.farleuchtenAnz do
           setVisibility(self.farleuchten[i].light, self.farleuchtenAn);
         end;
    end;



end;

function JD4850:update(dt)
	if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
			
	    end;
		
	end;

    --if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.FARMER_CAR_HORN) then
        --if not self.hornPlaying then
            --playSample(self.hornSoundId, 0, 1, 0);
            --self.hornPlaying = true;
        --end;
    --else
        --if self.hornPlaying then
            --stopSample(self.hornSoundId);
            --self.hornPlaying = false;
        --end;
    --end;
	if self.isHired or self.isEntered then
		self.fanRotation = self.fanRotation + 15 + math.max(self.motor.lastMotorRpm/50,0);
		setRotation(self.fan, 0, 0, Utils.degToRad(self.fanRotation));

		local rpm = math.max(self.motor.lastMotorRpm/50,0);
		local rpmDeltaMotion = math.max(self.motor.lastMotorRpm/300,0);
             
	      if self.incrementRotation == true then 
        		self.currentRotation = self.currentRotation + self.exhaustRotationSpeed;
	 	else
			self.currentRotation = self.currentRotation - self.exhaustRotationSpeed;
	 	end;

	  	if self.currentRotation >= (self.exhaustRotationMax - rpmDeltaMotion)then
			self.incrementRotation = false;
	 	elseif self.currentRotation <= (self.exhaustRotationMin + rpmDeltaMotion) then
  			self.incrementRotation = true;
	  	end;
	      setRotation(self.exhaustCover,Utils.degToRad(self.currentRotation+rpm), Utils.degToRad(180), 0);
	else 
		setRotation(self.exhaustCover, 0, Utils.degToRad(180), 0);
	end;

		if self.rotationPartTanknadel ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel.node);
			y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
			setRotation(self.rotationPartTanknadel.node, x, y ,z);
		end;
	
		if self.rotationPartTanknadel2 ~= nil then
			local x, y, z = getRotation(self.rotationPartTanknadel2.node);
			y = ((self.rotationPartTanknadel2.maxRot[2] - self.rotationPartTanknadel2.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel2.minRot[2];
			setRotation(self.rotationPartTanknadel2.node, x, y ,z);
		end;

		if self.isEntered then
		  if self.rundumleuchtenAn == true then
			setVisibility(self.roundLightDisplay, true);
		  else
			setVisibility(self.roundLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.frontleuchtenAn == true then
			setVisibility(self.lowLightDisplay, true);
		  else
			setVisibility(self.lowLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.farleuchtenAn == true then
			setVisibility(self.farLightDisplay, true);
		  else
			setVisibility(self.farLightDisplay, false);
	    	  end;
    		end;
		if self.isEntered then
		  if self.leuchtenAn == true then
			setVisibility(self.lightDisplay, true);
		  else
			setVisibility(self.lightDisplay, false);
	    	  end;
    		end;

	if self.isEntered then
		if not self.helpPanel then
			renderText(0.02, 0.2, 0.021, "Taste #: Infofenster");
		else
			renderText(0.02, 0.2, 0.021, "Taste #: Infofenster aus");
		end;
		if self.helpPanel then
			renderText(0.02, 0.44, 0.023, "- John Deere 8620 Info -");
			if self.twinWheelsActive then
				renderText(0.02, 0.42, 0.021, "Taste T: Normale Reifen");
			else
				renderText(0.02, 0.42, 0.021, "Taste T: Zwillingrder");
			end;
			if self.plowWheelsActive then
				renderText(0.02, 0.40, 0.021, "Taste Z: normal");
			else
				renderText(0.02, 0.40, 0.021, "Taste Z: nur links Doppelreifen");
			end;
			if self.worklightsActive then
				renderText(0.02, 0.38, 0.021, "Taste 5: Rundumlicht");
			else
				renderText(0.02, 0.38, 0.021, "Taste 5: Rundumlicht");
			end;
			--if self.flashLeft then
				--renderText(0.02, 0.38, 0.021, "Hit 6: Blinker Links Abschalten");
			--else
				--renderText(0.02, 0.38, 0.021, "Hit 6: Blinker Links Einschalten");
			--end;
			--if self.flashRight then
				--renderText(0.02, 0.34, 0.021, "Hit 8: Blinker Rechts Abschalten");
			--else
				--renderText(0.02, 0.34, 0.021, "Hit 8: Blinker Rechts Einschalten");
			--end;
			--if self.flash then
				--renderText(0.02, 0.36, 0.021, "Hit 7: Warnblinker Abschalten");
			--else
				--renderText(0.02, 0.36, 0.021, "Hit 7: Warnblinker Einschalten");
			--end;
			if self.worklightsActive then
				renderText(0.02, 0.36, 0.021, "Taste 4: Arbeitslicht");
			else
				renderText(0.02, 0.36, 0.021, "Taste 4: Arbeitslich");
			end;
			--renderText(0.02, 0.32, 0.021, "Hit 9/0: Zugmaul Hoch/Runter");
			--renderText(0.02, 0.30, 0.021, "Leertaste: Handbrake");
			--renderText(0.02, 0.28, 0.021, "Taste Bild hoch/runter: Gnge hoch/runter");
			--renderText(0.02, 0.26, 0.021, "Taste Enter: wechsel Automatik/Manual Getriebe");
			--renderText(0.02, 0.24, 0.021, "Hit NUM 8/5: Frontlader Kippen");
			--renderText(0.02, 0.22, 0.021, "Hit NUM 7/4: Frontlader Hoch/Runter");
			
		end;
	end;
	
	if self.isEntered then
        if self.rundumleuchtenAnz > 0 then
          if self.rundumleuchtenAn then
            for i=1, self.rundumleuchtenAnz do
              rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
            end;
          end;
        end;
      end;

	local speed = self.lastSpeed*3600;
	if self.gearShifter ~= nil and self.gearIndicator ~= nil then
		if self.movingDirection < 0 then
			setRotation(self.gearShifter, Utils.degToRad(-8.673), Utils.degToRad(4.336), Utils.degToRad(4.805));
            	setRotation(self.gearIndicator, Utils.degToRad(-36.173), Utils.degToRad(0), Utils.degToRad(0));
		else	
		if speed >= -0.5 and speed < 0.5 then
			setRotation(self.gearShifter, Utils.degToRad(-23.328), Utils.degToRad(5.284), Utils.degToRad(12.055));
			setRotation(self.gearIndicator, Utils.degToRad(-46.951), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 0.5 and speed < 2 then
			setRotation(self.gearShifter, Utils.degToRad(-22.025), Utils.degToRad(7.809), Utils.degToRad(13.667));
			setRotation(self.gearIndicator, Utils.degToRad(-31.471), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 2 and speed < 7 then
			setRotation(self.gearShifter, Utils.degToRad(-16.899), Utils.degToRad(7.809), Utils.degToRad(13.8));
			setRotation(self.gearIndicator, Utils.degToRad(-12.575), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 7 and speed < 15 then
			setRotation(self.gearShifter, Utils.degToRad(-11.528), Utils.degToRad(7.809), Utils.degToRad(14));
			setRotation(self.gearIndicator, Utils.degToRad(-3.313), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 15 and speed < 25 then
			setRotation(self.gearShifter, Utils.degToRad(-4), Utils.degToRad(7.809), Utils.degToRad(14.3));
			setRotation(self.gearIndicator, Utils.degToRad(5.885), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 25 and speed < 30 then
			setRotation(self.gearShifter, Utils.degToRad(1.495), Utils.degToRad(7.785), Utils.degToRad(14.608));
			setRotation(self.gearIndicator, Utils.degToRad(20.224), Utils.degToRad(0), Utils.degToRad(0));
		elseif speed >= 30 then			
			setRotation(self.gearShifter, Utils.degToRad(7.885), Utils.degToRad(7.596), Utils.degToRad(16.004));
			setRotation(self.gearIndicator, Utils.degToRad(32.669), Utils.degToRad(0), Utils.degToRad(0));
		end;
		end;
	end;


--Twin wheels etc begin
	if self.twinWheelsActive then 
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;
--Twin wheels etc ende

--Plow wheels etc begin
	if self.plowWheelsActive then
		for i=1, self.numPlowWheels do
			local plowWheel = self.plowWheels[i];
			setVisibility(plowWheel, self.plowWheelsActive);
		end;
	else
	   if not self.twinWheelsActive then
		for i=1, self.numPlowWheels do
			local plowWheel = self.plowWheels[i];
			setVisibility(plowWheel, self.plowWheelsActive, false);
		end;
	   end;
	end;
--Plow wheels etc ende
	if self.isEntered then
		if self.worklightsActive then
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive);
			end;
			setVisibility(self.workLightDisplay, self.worklightsActive); 
		else
			for i=1, self.numWorklights do
				local worklight = self.worklights[i];
				setVisibility(worklight, self.worklightsActive, false);
			end;
			setVisibility(self.workLightDisplay, false);
		end;
	end;

	--RPM Displays
	if self.isEntered then
		if self.frontleuchtenAn or self.farleuchtenAn then
			for i=1, self.numrpmlightdisplays do
          			if self.motor.lastMotorRpm >= self.rpmlightdisplays[i].rpmMinValue and self.motor.lastMotorRpm < self.rpmlightdisplays[i].rpmMaxValue then 
        				setVisibility(self.rpmlightdisplays[i].rotNode, true);
	    			else
					setVisibility(self.rpmlightdisplays[i].rotNode, false); 
	    			end;
      		end;
			for i=1, self.numrpmdisplays do
				setVisibility(self.rpmdisplays[i].rotNode, false); 
      		end;
		else
			for i=1, self.numrpmdisplays do
          			if self.motor.lastMotorRpm >= self.rpmdisplays[i].rpmMinValue and self.motor.lastMotorRpm < self.rpmdisplays[i].rpmMaxValue then 
        				setVisibility(self.rpmdisplays[i].rotNode, true);
	    			else
					setVisibility(self.rpmdisplays[i].rotNode, false); 
	    			end;
      		end;
			for i=1, self.numrpmlightdisplays do
				setVisibility(self.rpmlightdisplays[i].rotNode, false); 
      		end;
		end;
	end;
end;

function JD4850:draw()
    --g_currentMission:addHelpButtonText(g_i18n:getText("JD4850Horn"), InputBinding.FARMER_CAR_HORN);
	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
	    end;
	end;

end;

