
-- Chisel Plow
-- Author: Jeremy Brown
-- 12-18-13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

JD_2410 = {};

function JD_2410.prerequisitesPresent(specializations)
    return true;
end;

function JD_2410:load(xmlFile)
	self.setPoints = SpecializationUtil.callSpecializationsFunction("setPoints");
	
    self.pointsAnimationName = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Points#animationName"), "");
   
    if self.playAnimation == nil or self.getIsAnimationPlaying == nil then
        self.pointsAnimationName = "";
    end;
    self.pointsAnimationLowerSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Points#lowerSpeed"), 1);
    self.pointsAnimationLiftSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Points#liftSpeed"), -self.pointsAnimationLowerSpeed);

	self.isPointDown = false;
	
end;

function JD_2410:delete()
   
end;

function JD_2410:readStream(streamId, connection)
   
end;

function JD_2410:writeStream(streamId, connection)
   
end;

function JD_2410:readUpdateStream(streamId, timestamp, connection)
	
end;

function JD_2410:writeUpdateStream(streamId, connection, dirtyMask)
	
end;

function JD_2410:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
return BaseMission.VEHICLE_LOAD_OK;
end

function JD_2410:getSaveAttributesAndNodes(nodeIdent)

end

function JD_2410:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JD_2410:keyEvent(unicode, sym, modifier, isDown)
end;

function JD_2410:update(dt)
    if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self:setPoints(not self.isPointDown);
		end;
    end;
end;

function JD_2410:updateTick(dt)
		
end;

function JD_2410:draw()
    if self.isClient then
        if self:getIsActiveForInput(true) then

			if self.isPointDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POINTS_LIFT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POINTS_LOWER")), InputBinding.LOWER_IMPLEMENT);
			end;	
        end;   
    end;
end;

function JD_2410:onAttach(attacherVehicle)
	
end;

function JD_2410:onDetach()
   
end;

function JD_2410:onLeave()
   
end;

function JD_2410:onDeactivate()
	
end;

function JD_2410:onDeactivateSounds()
   
end;

function JD_2410:setPoints(isPointState, noEventSend)
	SetPointEvent.sendEvent(self, isPointState, noEventSend);
	-- Play Points animation --
	self.isPointDown = isPointState;
	if self.isPointDown then
		if self.pointsAnimationName ~= nil and self.playAnimation ~= nil then
            self:playAnimation(self.pointsAnimationName, self.pointsAnimationLowerSpeed, animTime, true)
			self.isPointDown = true;
		end;
	else
		if self.pointsAnimationName ~= nil and self.playAnimation ~= nil then
            self:playAnimation(self.pointsAnimationName, self.pointsAnimationLiftSpeed, animTime, true)
			self.isPointDown = false;
		end;
	end;
end;

-- Events
SetPointEvent = {};
SetPointEvent_mt = Class(SetPointEvent, Event);

InitEventClass(SetPointEvent, "SetPointEvent");

function SetPointEvent:emptyNew()
    local self = Event:new(SetPointEvent_mt);
    self.className="SetPointEvent";
    return self;
end;

function SetPointEvent:new(vehicle, isPointState)
    local self = SetPointEvent:emptyNew()
    self.vehicle = vehicle;
	self.isPointState = isPointState;
    return self;
end;

function SetPointEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isPointState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPointEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isPointState);
end;

function SetPointEvent:run(connection)   
	self.vehicle:setPoints(self.isPointState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPointEvent:new(self.vehicle, self.isPointState), nil, connection, self.vehicle);
    end;
end;

function SetPointEvent.sendEvent(vehicle, isPointState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPointEvent:new(vehicle, isPointState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPointEvent:new(vehicle, isPointState));
		end;
	end;
end;