--
-- feedAnimals
-- Class for diet animals feeder
--
-- @author  PeterJ - euroDZN
-- @date  27/03/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

feedAnimals = {};
  
function feedAnimals.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;
  
function feedAnimals:load(xmlFile)

	self.eatSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animals#eatSpeed"), 0.0);
	if self.eatSpeed > 0 then
		self.eatSpeed = self.eatSpeed * 2.3;
	end;
	self.animalsCanEat = true;
end;

function feedAnimals:delete()
end;

function feedAnimals:readStream(streamId, connection)
end;

function feedAnimals:writeStream(streamId, connection)
end;

function feedAnimals:readUpdateStream(streamId, timestamp, connection)
end;

function feedAnimals:writeUpdateStream(streamId, connection, dirtyMask)
end;

function feedAnimals:mouseEvent(posX, posY, isDown, isUp, button)
end;

function feedAnimals:keyEvent(unicode, sym, modifier, isDown)
end;

function feedAnimals:update(dt)
end;

function feedAnimals:updateTick(dt)
	if self.animalsCanEat then
		local cowsStored = g_currentMission.husbandries.cow.totalNumAnimals;
		local sheepStored = g_currentMission.husbandries.sheep.totalNumAnimals;
		if cowsStored > 0 or sheepStored > 0 then
			local thirstyAnimals = cowsStored + sheepStored;
			local eatSpeed = thirstyAnimals;
			if thirstyAnimals > 65 then
				eatSpeed = 65;
			end;
			self:setFillLevel(self.fillLevel - (eatSpeed / self.eatSpeed), self.currentFillType);
		end;
	end;
end;

function feedAnimals:draw()
	if self.isClient then
		if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
			g_currentMission:setFillTypeOverlayFillType(self.currentFillType);
		end;
	end;
end;

function feedAnimals:onAttach(attacherVehicle)
	self.animalsCanEat = false;
end;

function feedAnimals:onDetach()
	self.animalsCanEat = true;
end;

function feedAnimals:onLeave()
end;

function feedAnimals:onDeactivate()
end;
  
function feedAnimals:onDeactivateSounds()
end;
