--
-- ExtraWeights
-- Specialization for extra weights on vehicles
--
--	@author:			unbekannt
--	@version: 			1.0
--
--
--	@author:			gotchTOM
--	@date: 				27-May-2012
--	@version: 			v1.01 test version!
--
--	@history:			v1.0 	- initial version (FS 2008? / FS 2009?)
--						v1.01 	- multiplayer ready version (FS 2011)


ExtraWeights = {};

function ExtraWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function ExtraWeights:load(xmlFile)

	self.setExtraWeights = SpecializationUtil.callSpecializationsFunction("setExtraWeights");
	
	self.extraWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraWeights#count"), 0);
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 0);
	
    self.weights = {};
    for i=1, self.extraWeights do
        local weightnamei = string.format("vehicle.extraWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	if self.extraWeights ~= 0 then
		self.singleWeight = (self.maxWeight / self.extraWeights);
	end;
	
end;

function ExtraWeights:readStream(streamId, connection)   

	self.currentWeight = streamReadFloat32(streamId);
	if self.weights ~= nil and self.extraWeights > 0 then
		if self.currentWeight ~= self.controlWeight then
			self.controlWeight = self.currentWeight;
		
			if self.currentWeight > 0 then
				for i = 1, self.extraWeights do
					if i * self.singleWeight <= self.currentWeight then
						setVisibility(self.weights[i], true);
					end;
				end;
			else
				for i = 1, self.extraWeights do
					setVisibility(self.weights[i], false);
				end;
			end;
		end;

		if self.emptyMass == nil then
			self.emptyMass = getMass(self.components[1].node);
			self.currentMass = self.emptyMass;
		end;
		local newMass = self.emptyMass + self.currentWeight/2500;
		if newMass ~= self.currentMass then
			setMass(self.components[1].node, newMass);
			self.currentMass = newMass;
			for k,v in pairs(self.components) do
				if v.node == self.components[1].node then
					if v.centerOfMass ~= nil then
						setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
					end;
					break;
				end;
			end;
		end;
	end;
end;

function ExtraWeights:writeStream(streamId, connection)  

	streamWriteFloat32(streamId, self.currentWeight);
end;

function ExtraWeights:delete()
end;

function ExtraWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtraWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtraWeights:update(dt)
	
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.TOGGLE_EXTRAWEIGHT) and self.extraWeights > 0 then
				
				if self.currentWeight >= self.maxWeight then
					self.currentWeight = 0;
				else
					self.currentWeight = self.currentWeight + self.singleWeight;
				end;
				self:setExtraWeights(self.currentWeight)
			end;
		end;
	end;	
end;

function ExtraWeights:updateTick(dt)
	
	if self:getIsActive() then
		if self.weights ~= nil and self.extraWeights > 0 then
			if self.currentWeight ~= self.controlWeight then
				self.controlWeight = self.currentWeight;
			
				if self.currentWeight > 0 then
					for i = 1, self.extraWeights do
						if i * self.singleWeight <= self.currentWeight then
							setVisibility(self.weights[i], true);
						end;
					end;
				else
					for i = 1, self.extraWeights do
						setVisibility(self.weights[i], false);
					end;
				end;
			end;

			if self.emptyMass == nil then
				self.emptyMass = getMass(self.components[1].node);
				self.currentMass = self.emptyMass;
			end;
			local newMass = self.emptyMass + self.currentWeight/1000;
			if newMass ~= self.currentMass then
				setMass(self.components[1].node, newMass);
				self.currentMass = newMass;
				for k,v in pairs(self.components) do
					if v.node == self.components[1].node then
						if v.centerOfMass ~= nil then
							setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
						end;
						break;
					end;
				end;
			end;
		end;
	end;
end;

function ExtraWeights:draw()
	
	if self.extraWeights > 0 then
		if self.maxWeight >= 1000 then
			if self.currentWeight >= 1000 then
				g_currentMission:addHelpButtonText(string.format("%st "..g_i18n:getText("extraWeightsTxt1").." %st "..g_i18n:getText("extraWeightsTxt2"), self.currentWeight/1000, self.maxWeight/1000), InputBinding.TOGGLE_EXTRAWEIGHT);
			else				
				g_currentMission:addHelpButtonText(string.format("%skg "..g_i18n:getText("extraWeightsTxt1").." %st "..g_i18n:getText("extraWeightsTxt2"), self.currentWeight, self.maxWeight/1000), InputBinding.TOGGLE_EXTRAWEIGHT);
			end;	
		else
			g_currentMission:addHelpButtonText(string.format("%skg "..g_i18n:getText("extraWeightsTxt1").." %skg "..g_i18n:getText("extraWeightsTxt2"), self.currentWeight, self.maxWeight), InputBinding.TOGGLE_EXTRAWEIGHT);
		end;
		
	end;
end;

function ExtraWeights:setExtraWeights(currentWeight, noEventSend)

	if noEventSend == nil or noEventSend == false then	
		SetExtraWeightsEvent.sendEvent(self, currentWeight, noEventSend); 	
	end;
	
	self.currentWeight = currentWeight;
end;


SetExtraWeightsEvent = {};
SetExtraWeightsEvent_mt = Class(SetExtraWeightsEvent, Event);

InitEventClass(SetExtraWeightsEvent, "SetExtraWeightsEvent");

function SetExtraWeightsEvent:emptyNew()
  
    local self = Event:new(SetExtraWeightsEvent_mt);
    self.className="SetExtraWeightsEvent";
    return self;
end;

function SetExtraWeightsEvent:new(vehicle, currentWeight)

    local self = SetExtraWeightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentWeight = currentWeight;
    return self;
end;

function SetExtraWeightsEvent:readStream(streamId, connection) 

    local id = streamReadInt32(streamId); 
	self.currentWeight = streamReadFloat32(streamId);  
    self.vehicle = networkGetObject(id); 
    self:run(connection);
end;

function SetExtraWeightsEvent:writeStream(streamId, connection) 
  
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteFloat32(streamId, self.currentWeight);
end;

function SetExtraWeightsEvent:run(connection) 
  
	if not connection:getIsServer() then	
		for k, v in pairs(g_server.clientConnections) do
			if v ~= connection and not v:getIsLocal() then
				v:sendEvent(SetExtraWeightsEvent:new(self.vehicle, self.currentWeight));
			end;
		end;
	end;	
	self.vehicle:setExtraWeights(self.currentWeight, true); 
end;

function SetExtraWeightsEvent.sendEvent(vehicle, currentWeight, noEventSend)  
		
	if g_server ~= nil then  
		g_server:broadcastEvent(SetExtraWeightsEvent:new(vehicle, currentWeight), nil, nil, vehicle);
	else  
		g_client:getServerConnection():sendEvent(SetExtraWeightsEvent:new(vehicle, currentWeight));
	end;
end;

