SetLevelEvent = {};
SetLevelEvent_mt = Class(SetLevelEvent, Event);

InitEventClass(SetLevelEvent, "SetLevelEvent");

function SetLevelEvent:emptyNew()
    local self = Event:new(SetLevelEvent_mt);
    self.className="SetLevelEvent";
    return self;
end;

function SetLevelEvent:new(vehicle, direction)
    local self = SetLevelEvent:emptyNew()
    self.vehicle = vehicle;
	self.direction = direction;
    return self;
end;

function SetLevelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.direction = streamWriteInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLevelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.direction);
end;

function SetLevelEvent:run(connection)   
	self.vehicle:setLevel(self.direction, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLevelEvent:new(vehicle, self.direction), nil, connection, self.vehicle);
    end;
end;

function SetLevelEvent.sendEvent(vehicle, direction, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLevelEvent:new(vehicle, direction), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLevelEvent:new(vehicle, direction));
		end;
	end;
end;