--
-- ESLimiter
-- Specialization for ESLimiter
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		05/11/10
-- @version:	v2.1
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 and some bugfixes
--				v2.1 - Network-Fixes
--

ESLimiter = {};

function ESLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ESLimiter:load(xmlFile)

	self.setNewLimit = SpecializationUtil.callSpecializationsFunction("setNewLimit");

	self.ESLimiter = {};
	self.ESLimiter.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posX"), 0.7543);
	self.ESLimiter.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posY"), 0.1715);
	self.ESLimiter.maxRPM = {};
	self.ESLimiter.percentage = {};
	for k,v in pairs(self.motor.maxRpm) do
		self.ESLimiter.maxRPM[k] = self.motor.maxRpm[3];
		local percentage = string.format("%d",(self.motor.maxRpm[k]* 100 / self.motor.maxRpm[3]));
		self.ESLimiter.percentage[k] = tonumber(percentage); -- percentage
	end;

	self.eslOverlay = Overlay:new("hudESLOverlay", Utils.getFilename("Scripts/ESLimiter_hud.dds", self.baseDirectory), self.ESLimiter.xPos, self.ESLimiter.yPos, 0.2371, 0.039525);
	self.lastButtonDown = nil;
	self.isLimiterActive = false;
end;

function ESLimiter:delete()
end;

function ESLimiter:readStream(streamId, connection)
	for level,_ in pairs(self.ESLimiter.percentage) do
		local percentage = streamReadInt8(streamId);
		self:setNewLimit(level, percentage, false, true);
	end;
end;

function ESLimiter:writeStream(streamId, connection)
	for _,percentage in pairs(self.ESLimiter.percentage) do
		streamWriteInt8(streamId, percentage);
	end;
end;

function ESLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ESLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function ESLimiter:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			local currentLevel = self.motor.speedLevel;
			if self.movingDirection < 0 then
				currentLevel = 1;
			end;

			if currentLevel ~= 0 then
				local percentage = self.ESLimiter.percentage;
				if InputBinding.isPressed(InputBinding.ESLimiter_PLUS) and percentage[currentLevel] < 100 then
					self.lastButtonDown = InputBinding.ESLimiter_PLUS;
					percentage[currentLevel] = percentage[currentLevel] + 1;
					-- don't send event to other players
					self:setNewLimit(currentLevel, percentage[currentLevel], false, true);
				elseif InputBinding.isPressed(InputBinding.ESLimiter_MINUS) and percentage[currentLevel] > 10 then
					percentage[currentLevel] = percentage[currentLevel] - 1;
					self.lastButtonDown = InputBinding.ESLimiter_MINUS;
					-- don't send event to other players
					self:setNewLimit(currentLevel, percentage[currentLevel], false, true);
				else
					if self.lastButtonDown ~= nil then
						-- only send event to other players if key was released -> performance issue
						self:setNewLimit(currentLevel, percentage[currentLevel], false);
						self.lastButtonDown = nil;
					end;	
				end;
				self.isLimiterActive = true;
			else
				if self.isLimiterActive then
					self:setNewLimit(3, 100, true);
					self.isLimiterActive = false;
				end;
				self.motor.maxRpm[3] = self.ESLimiter.maxRPM[3];
			end;
		end;
	end;
end;

function ESLimiter:draw()
	local currentLevel = self.motor.speedLevel;
	local text = "Deaktiviert";
	if self.movingDirection < 0 then
		currentLevel = 1;
	end;
	if currentLevel ~= 0 then
		local percentage = tonumber(string.format("%d", self.ESLimiter.percentage[currentLevel]));
		if percentage < 100 then
			percentage = " " .. percentage;
		end;
		text = g_i18n:getText("ESLimiter_level") .. currentLevel .. ":" .. percentage .. "% ";	
	end;
	self.eslOverlay:render();
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_LEFT);
	renderText(self.ESLimiter.xPos + 0.13, self.ESLimiter.yPos + 0.0085, 0.02, text);
	g_currentMission:addExtraPrintText(string.format(g_i18n:getText("ESLimiter_controls"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter_PLUS) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter_MINUS));
end;

function ESLimiter:setNewLimit(level, percentage, doRestoreLimit, noEventSend)	
	ESLimiterEvent.sendEvent(self, level, percentage, doRestoreLimit, noEventSend);	
	local currentRPM = self.ESLimiter.maxRPM;
	if not doRestoreLimit then
		self.ESLimiter.percentage[level] = percentage;
		if self.movingDirection > 0 then
			self.motor.maxRpm[level] = tonumber(string.format("%d",(percentage * currentRPM[level] / 100)));
		else
			self.motor.maxRpm[3] = tonumber(string.format("%d",(percentage * currentRPM[level] / 100)));
		end;
	else
		self.motor.maxRpm[3] = self.ESLimiter.maxRPM[3];
	end;
end;


function ESLimiter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#limiterValues");		
		if valueStr ~= nil then
			local found = string.find(valueStr, ";");
			local index = 1;
			while found ~= nil do
				local value = string.sub(valueStr, 0, found-1);
				valueStr = string.sub(valueStr, found+1);
				found = string.find(valueStr, ";");
				self.ESLimiter.percentage[index] = tonumber(value);
				if found == nil then
					self.ESLimiter.percentage[index+1] = tonumber(valueStr);
				end;
				index = index + 1;	
			end;
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function ESLimiter:getSaveAttributesAndNodes(nodeIdent)
	local values = "";	
	for k,v in pairs(self.ESLimiter.percentage) do
		if k ~= 1 then
			values = values .. ";";
		end;
		values = values .. string.format("%d", v);
	end;
	
    local attributes = 'limiterValues="'.. values .. '"';
    return attributes, nil;
end;
function ESLimiter:validateAttacherJoint(implement, jointDesc, dt) 
return true; 
end; 
