--
-- BuyableCareWheelsAttacher
-- Specialization for Buyable Care Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--
-- @DATE  		01/08/13 ADD FIX FOR USE JD 7R SERIES Ago-Systemtech,(Modhoster team)
-- free for non commercial-usage
--

BuyableCareWheelsAttacher = {};

function BuyableCareWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableCareWheelsAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.compraGomme = {};
	self.compraGomme.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#careWheelsCheckString"), "standart");
	
	-- Rowcrop wheels
	self.compraGomme.careWheels = nil;
	self.compraGomme.carewheelsInRange = nil;
    -- Rear dual wheels
    self.compraGomme.twinWheels = nil;
	self.compraGomme.twinwheelsInRange = nil;	
end;

function BuyableCareWheelsAttacher:delete()
	if self.compraGomme.careWheels ~= nil then
		self.compraGomme.careWheels:disassembleWheels(true);
	end;
	if self.compraGomme.twinWheels ~= nil then
		self.compraGomme.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableCareWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableCareWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableCareWheelsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.compraGomme;
		
		if wheels.carewheelsInRange ~= nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.BUYABLE_CAREWHEELS) then
					if wheels.careWheels == nil then
						wheels.carewheelsInRange:assembleWheels(self);
					else
						if wheels.carewheelsInRange.careWheelUser == self and wheels.twinWheels == nil then
							wheels.carewheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;
		if wheels.twinwheelsInRange ~= nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.JDBuyableDualRear) then
					if wheels.twinWheels == nil and wheels.careWheels ~= nil then
						wheels.twinwheelsInRange:assembleWheels(self);
					else
						if wheels.twinwheelsInRange.twinWheelsUser == self then
							wheels.twinwheelsInRange:disassembleWheels(self);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableCareWheelsAttacher:draw()
	local wheels = self.compraGomme;
	
	if wheels.carewheelsInRange ~= nil then
		if wheels.careWheels ~= nil then
			if wheels.carewheelsInRange.careWheelUser == self and wheels.twinWheels == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCareWheels_disassemble"), InputBinding.BUYABLE_CAREWHEELS);
			end;
		else
			if wheels.carewheelsInRange.careWheelUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCareWheels_assemble"), InputBinding.BUYABLE_CAREWHEELS);
			end;
		end;
	end;
	if wheels.twinwheelsInRange ~= nil and wheels.careWheels ~= nil then
		if wheels.twinWheels ~= nil then
			if wheels.twinwheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.JDBuyableDualRear);
			end;
		else
			if wheels.twinwheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.JDBuyableDualRear);
			end;
		end;
	end;
	
end;

function BuyableCareWheelsAttacher:onAssembling(compraGomme)
	if compraGomme.careWheelUser ~= nil then
		self.compraGomme.careWheels = compraGomme;
	elseif compraGomme.twinWheelsUser ~= nil then
		self.compraGomme.twinWheels = compraGomme;
	end;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(true);
	end;
end;

function BuyableCareWheelsAttacher:onDisassembling(compraGomme)
	if compraGomme.twinWheelsUser ~= nil then
		self.compraGomme.twinWheels = nil;
	elseif	compraGomme.careWheelUser ~= nil then
		self.compraGomme.careWheels = nil;
	
	end;
	 if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(false);
	end;
end;

