--
-- Fenderscript for John Deere 7930
--
-- M@D Author:  Heady
-- M@D date: 07.08.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Fender = {};

function Fender.prerequisitesPresent(specializations)
    return true;
end;

function Fender:load(xmlFile)
	
	self.fender = {};
	self.fender.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#leftIndex"));
	self.fender.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fender#rightIndex"));
	self.fender.leftRotMax = getXMLInt(xmlFile, "vehicle.fender#leftRotMax");
	self.fender.rightRotMax = getXMLInt(xmlFile, "vehicle.fender#rightRotMax");

	
end;

function Fender:delete()
end;

function Fender:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fender:keyEvent(unicode, sym, modifier, isDown)
end;

--function Fender:readStream(streamId, connection)
--end;

--function Fender:writeStream(streamId, connection)
--end;

function Fender:update(dt)

    if self:getIsActive() then
		
		local x1,y1,z1 = getRotation(self.wheels[1].repr);
		if y1 < math.rad(self.fender.rightRotMax) then
			setRotation(self.fender.rightNode, 0, math.rad(4), 0);
		else
			setRotation(self.fender.rightNode, 0, 0, 0);
		end;
		
		local x2,y2,z2 = getRotation(self.wheels[2].repr);
		if y2 > math.rad(self.fender.leftRotMax) then
			setRotation(self.fender.leftNode, 0, math.rad(-4), 0);
		else
			setRotation(self.fender.leftNode, 0, 0, 0);
		end;
	
	end;



end;

function Fender:updateTick(dt)
end;

function Fender:draw()	
end;