TwinWheels = {};

function TwinWheels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TwinWheels:load(xmlFile)
self.settwinWheels = SpecializationUtil.callSpecializationsFunction("settwinWheels");
	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;
    self.twinWheelsActive= false;	
end;
function TwinWheels:readStream(streamId, connection)
	self:settwinWheels(streamReadBool(streamId), true);
end;

function TwinWheels:writeStream(streamId, connection)
	streamWriteBool(streamId, self.twinWheelsActive);
end;
function TwinWheels:keyEvent(unicode, sym, modifier, isDown)
end;


function TwinWheels:update(dt)
	if self.isEntered and InputBinding.hasEvent(InputBinding.HTWINS) then
		self:settwinWheels(not self.twinWheelsActive);
	end;
	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;	
end; 
function TwinWheels:settwinWheels(state, noSendEvent)
	self.twinWheelsActive = state;
	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;	
	if noSendEvent ~= true then
		TwinWheelsEvent.sendEvent(self, TwinWheelsEventType.TwinWheels, self.twinWheelsActive);
	end;
end;

function TwinWheels:draw()
  if self:getIsActiveForInput() then
		if self.twinWheelsActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("SINGLE_WHEELS"), InputBinding.HTWINS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("DUAL_WHEELS"), InputBinding.HTWINS);
		end;
	end;
end;
function TwinWheels:onEnter()
   
end;
function TwinWheels:onLeave()
end;
function TwinWheels:delete()
end;
function TwinWheels:mouseEvent(posX, posY, isDown, isUp, button)
end;