--
-- JohnDeere2140
-- Specialization class for John Deere 7280R
--
-- @author  Mario
-- @date  24/08/2010
--
-- Copyright (C) Mario, All Rights Reserved.

JohnDeere2140 = {};

function JohnDeere2140.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JohnDeere2140:load(xmlFile)
	
	self.maxTranslationPrCycle = 0.00008;
	
	-- Front axle animation
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));
	
	-- Animated wheels
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;
	
	self.clutchPedal = {};
	self.clutchPedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.clutchPedal#index"));
	self.clutchPedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#maxRot"), 0));
	self.clutchPedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#minRot"), 0));
	self.clutchPedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.clutchPedal#movementSpeed"), 0)/1000;
	
	self.brakePedal = {};
	self.brakePedal.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.brakePedal#index"));
	self.brakePedal.maxRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#maxRot"), 0));
	self.brakePedal.minRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#minRot"), 0));
	self.brakePedal.movementSpeed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.brakePedal#movementSpeed"), 0)/1000;
	
	self.exhaustFlap = {};
	self.exhaustFlap.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaustFlap#index"));
	self.exhaustFlap.startRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.exhaustFlap#startRot"), 0));
	
	self.CoolingFan = {};
	self.CoolingFan.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.CoolingFan#index"));
	self.CoolingFan.speed = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.CoolingFan#speed"), 0.006);
	self.CoolingFan.currentSpeed = self.CoolingFan.speed;
	self.CoolingFan.invertedSpeed = -self.CoolingFan.speed;
end;

function JohnDeere2140:delete()

end;

function JohnDeere2140:readStream(streamId, connection)
end;

function JohnDeere2140:writeStream(streamId, connection)
end;

function JohnDeere2140:readUpdateStream(streamId, timestamp, connection)
	
end;

function JohnDeere2140:writeUpdateStream(streamId, connection, dirtyMask)
	
end;

function JohnDeere2140:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere2140:keyEvent(unicode, sym, modifier, isDown)
	
end;

function JohnDeere2140:update(dt)
	
	if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[1].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[2].repr);
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);

        setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);

		local x2,y2,z2 = getRotation(self.frontAxle.rotNode);

		--renderText(0.5, 0.65, 0.040, "x=" .. string.format((x2/3.14) * 180));
		--renderText(0.5, 0.75, 0.040, "y=" .. string.format((y2/3.14) * 180));
		--renderText(0.5, 0.85, 0.040, "z=" .. string.format((z2/3.14) * 180));

		setRotation(self.frontAxle.rotNode,x2 - 1.571,y3,z2 - 1.571);
	end;
	
	-- Making the visible wheels rotate
	if self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local x,y,z = getRotation(self.wheels[1].driveNode);
		local x2,y2,z2 = getRotation(self.wheels[1].repr);
		setRotation(self.animatedWheel[1].wheel, x,y,z);
		setRotation(self.animatedWheel[1].rotNode, x2,y2,z2);

		local x3,y3,z3 = getRotation(self.wheels[2].driveNode);
		local x4,y4,z4 = getRotation(self.wheels[2].repr);
		setRotation(self.animatedWheel[2].wheel, x3,y3,z3);
		setRotation(self.animatedWheel[2].rotNode, x4,y4,z4);
	end;
	
	-- Dynamic fenders
	if self.animatedWheel[1].fenderAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil then
		local x, y, z = getRotation(self.animatedWheel[1].rotNode);
		local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);

		local fenderYRot = (y * 0.6 - self.maxTranslationPrCycle * dt);
		local fenderY2Rot = (y2 * 0.6 - self.maxTranslationPrCycle * dt);

		setRotation(self.animatedWheel[1].fenderAttach, x, fenderYRot, z);
		setRotation(self.animatedWheel[2].fenderAttach, x2, fenderY2Rot, z2);

		--local x3,y3,z3 = getRotation(self.animatedWheel[1].fenderAttach);
		--renderText(0.5, 0.65, 0.040, string.format(y3));

		--local x4,y4,z4 = getRotation(self.animatedWheel[2].fenderAttach);
		--renderText(0.5, 0.55, 0.040, string.format(y4));
	end;
	
	if self:getIsActive() then
		if self.ignitionMode == nil or self.ignitionMode >= 1 then
			if self.exhaustFlap.index ~= nil and self.ignitionMode >= 2 then
				local rpmRotation = 0;
				if self.motor.lastMotorRpm == self.motor.minRpm then
					rpmRotation = math.random(self.exhaustFlap.startRot-0, self.exhaustFlap.startRot+30);
					rpmRotation = math.rad(rpmRotation);
				else
					rpmRotation = math.rad(self.motor.lastMotorRpm/15);
					rpmRotation = rpmRotation - self.exhaustFlap.startRot;
				end;
				setRotation(self.exhaustFlap.index, 0, -rpmRotation, 0);
			end;
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 or self.lastAcceleration == 0 then
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX > self.clutchPedal.maxRot then
						setRotation(self.clutchPedal.index, rotX - dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			else
				if self.clutchPedal.index ~= nil then
					local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
					if rotX < self.clutchPedal.minRot then
						setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
			
			if self.movingDirection == 1 and self.lastAcceleration <= 0 or self.movingDirection == -1 and self.lastAcceleration >= 0 then
				if self.brakePedal.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
					if rotX1 > self.brakePedal.maxRot then
						setRotation(self.brakePedal.index, rotX1 - dt * (self.brakePedal.movementSpeed/2), rotY, rotZ);
					end;
				end;
			else
				if self.brakePedal.index ~= nil then
					local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
					if rotX1 < self.brakePedal.minRot then
						setRotation(self.brakePedal.index, rotX1 + dt * self.brakePedal.movementSpeed, rotY, rotZ);
					end;
				end;
			end;
		else
			if self.clutchPedal.index ~= nil then
				local rotX, rotY, rotZ = getRotation(self.clutchPedal.index);
				if rotX < self.clutchPedal.minRot then
					setRotation(self.clutchPedal.index, rotX + dt * self.clutchPedal.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.brakePedal.index ~= nil then
				local rotX1, rotY1, rotZ1 = getRotation(self.brakePedal.index);
				if rotX1 < self.brakePedal.minRot then
					setRotation(self.brakePedal.index, rotX1 + dt * self.brakePedal.movementSpeed, rotY, rotZ);
				end;
			end;
			
			if self.exhaustFlap.index ~= nil then
				setRotation(self.exhaustFlap.index, 0, self.exhaustFlap.startRot+math.rad(10), 0);
			end;
		end;
	end;
end;

function JohnDeere2140:updateTick(dt)
	if self:getIsActive() then
		if self.ignitionMode == nil or self.ignitionMode >= 1 then
			self.CoolingFan.currentSpeed = self.CoolingFan.speed*self.motor.lastMotorRpm;
			rotate(self.CoolingFan.node, 0, 0, -dt*self.CoolingFan.currentSpeed);
		else
			setRotation(self.CoolingFan.node, 0, 0, 0);
		end;
	end;
end;

function JohnDeere2140:draw()
	
end;

function JohnDeere2140:validateAttacherJoint(implement, jointDesc, dt)
	return true;
end;

function JohnDeere2140:onEnter()
	
end;

function JohnDeere2140:startMotor()
	
end;

function JohnDeere2140:onLeave()
	
end;
