-- alarm70Sound
-- Specialization pro alarm70Sound
--
-- @version: 1.2 (oitno) ze dne 8.9.2013
-- @author:  Dylan, EDV, Mr.Zero, Kardis - NSMT
-- Pro vytvoreni zvuku alarmu pri naplneni zasobniku na 80%.
-- (pri uprave procent nutno prepocitat pomerova procenta podminky!)
-- !!!!script nutno prejmenovat na alarm70Sound.lua!!!!
--[[ Zapis do XML souboru stroje :
	*****************************

    <alarm70Sound file="vybrany zvuk" pitchOffset="1" volume="0.4" />   

    Vysvetlivky k funkcim:
	pitchOffset		- frekvence prehravani zvuku (pri nezadani defaultne hodnota "1" = 1:1) (nen nutn parametr menit, pro zachovani realneho zvuku)
	volume			- hlasitost zvuku (pri nezadani defaultne hodnota "1" = 1:1) (nutno doladit dle hlasitosti stroje)
------------------------------------------------------------------------------------
 Zapis do souboru modDesc.xml :
	******************************
	
	vsadit do <specializations> :
		<specialization name="alarm70Sound" className="alarm70Sound" filename="alarm70Sound.lua"/> 
	
	vsadit do <vehicleTypes> :
		<specialization name="alarm70Sound"/>

**************************************************************************************************************************]]--
		
		
alarm70Sound = {};

function alarm70Sound.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function alarm70Sound:load(xmlFile)
    local alarm70Sound = getXMLString(xmlFile, "vehicle.alarm70Sound#file");
    if alarm70Sound ~= nil and alarm70Sound ~= "" then
       alarm70Sound = Utils.getFilename(alarm70Sound, self.baseDirectory);
       self.alarm70Sound = createSample("alarm70Sound");
       self.alarm70SoundEnabled = false;
       loadSample(self.alarm70Sound, alarm70Sound, false);
       self.alarm70SoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.alarm70Sound#volume"), 1);
    end;
	
end;
function alarm70Sound:delete()
    if self.alarm70Sound ~= nil then
       delete(self.alarm70Sound);
       self.alarm70SoundEnabled = false;
    end;
end;
function alarm70Sound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function alarm70Sound:keyEvent(unicode, sym, modifier, isDown)
end;
function alarm70Sound:update(dt)
end;

function alarm70Sound:draw()
if self.grainTankFillLevel > (self.grainTankCapacity * 0.8) and self.grainTankFillLevel < (self.grainTankCapacity * 0.801) and self:getIsActiveForSound() then
			playSample(self.alarm70Sound,1,1,0, self.alarm70SoundVolume, 20);
            self.alarm70SoundEnabled = true;
	else
           self.alarm70SoundEnabled = false;
	end;
	self.alarm70SoundEnabled = false;
end;