SpecializationUtil.registerSpecialization("esLimiter", "ESLimiter", g_currentModDirectory.."ESLimiter.lua")

ESLimiter_Register = {};

function ESLimiter_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		print("--- loading ESLimiter - specialization for ESLimiter + OperatingHours by Manuel Leithner (SFM-Modding)");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("steerable") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.ESLimiter", _name)) ~= nil then
								allowInsertion = false;
								-- print(tostring(v.name)..": Specialization ESLimiter is present! ESLimiter was not inserted!");
							end;
							if rawget(SpecializationUtil.specializations, string.format("%s.operatingHours", _name)) ~= nil then
								allowInsertion = false;
								-- print(tostring(v.name)..": Specialization operatingHours is present! ESLimiter was not inserted!");
							end;
							if rawget(SpecializationUtil.specializations, string.format("%s.OperatingHours", _name)) ~= nil then
								allowInsertion = false;
								-- print(tostring(v.name)..": Specialization OperatingHours is present! ESLimiter was not inserted!");
							end;
						end;
						if allowInsertion then
							-- print("adding ESLimiter to:"..tostring(v.name));
							table.insert(v.specializations, SpecializationUtil.getSpecialization("esLimiter"));
						end;
						
						vs.ESL_DEACTIVATED = g_i18n:getText("ESLimiter_deactivated");
						vs.ESL_LEVEL = g_i18n:getText("ESLimiter_level");
						vs.ESL_CONTROLS = g_i18n:getText("ESLimiter_controls");
					end;
				end;
			end;	
		end;
	end;
end;

function ESLimiter_Register:deleteMap()
  
end;

function ESLimiter_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function ESLimiter_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ESLimiter_Register:update(dt)
	
end;

function ESLimiter_Register:draw()
  
end;

addModEventListener(ESLimiter_Register);