--
-- E512VariatorAndGear v1.0 BETA
--
-- 05/2013 by Saty / http://forum.lsczech.cz
--

E512VariatorAndGear = {};

function E512VariatorAndGear.prerequisitesPresent(specializations)
    return true;
end;

function E512VariatorAndGear:load(xmlFile)
	self.variatorAndGear = {};
	self.variatorAndGear.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.E512VariatorAndGear.variator#node"));
	local rotMin = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.variator#rotMin");
	local rotMax = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.variator#rotMax");
	if rotMin ~= nil and rotMax ~= nil then
		local x,y,z = Utils.getVectorFromString(rotMin);
		self.variatorAndGear.rotMin = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		local x,y,z = Utils.getVectorFromString(rotMax);
		self.variatorAndGear.rotMax = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
	end;
	self.variatorAndGear.moveTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.E512VariatorAndGear.variator#moveTime"),1)*1000;
	
	self.variatorAndGear.nodeV = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#nodeV"));
	self.variatorAndGear.nodeH = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#nodeH"));
	local rotMinV = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#rotMinV");
	local rotNulV = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#rotNulV");
	local rotMaxV = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#rotMaxV");
	local transMinH = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#transMinH");
	local transNulH = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#transNulH");
	local transMaxH = getXMLString(xmlFile, "vehicle.E512VariatorAndGear.gearShift#transMaxH");
	if rotMinV ~= nil and rotNulV ~= nil and rotMaxV ~= nil and transMinH ~= nil and transNulH ~= nil and transMaxH ~= nil then
		local x,y,z = Utils.getVectorFromString(rotMinV);
		self.variatorAndGear.rotMinV = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		local x,y,z = Utils.getVectorFromString(rotNulV);
		self.variatorAndGear.rotNulV = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		local x,y,z = Utils.getVectorFromString(rotMaxV);
		self.variatorAndGear.rotMaxV = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		local x,y,z = Utils.getVectorFromString(transMinH);
		self.variatorAndGear.transMinH = {Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0)};
		local x,y,z = Utils.getVectorFromString(transNulH);
		self.variatorAndGear.transNulH = {Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0)};
		local x,y,z = Utils.getVectorFromString(transMaxH);
		self.variatorAndGear.transMaxH = {Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0)};
	end;
	
	self.variatorAndGear.moveTimeV = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.E512VariatorAndGear.gearShift#moveTimeV"),1)*1000;
	self.variatorAndGear.moveTimeH = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.E512VariatorAndGear.gearShift#moveTimeH"),1)*1000;
	
	self.variatorAndGear.level = 0;
	self.variatorAndGear.VtoMax = false;
	self.variatorAndGear.VtoMin = false;
	self.variatorAndGear.HtoMax = false;
	self.variatorAndGear.HtoMin = false;
end;

function E512VariatorAndGear:update(dt)
	if self:getIsActive() then
		if self.variatorAndGear.node ~= nil and self.variatorAndGear.nodeV ~= nil and self.variatorAndGear.nodeH ~= nil then
			local curRotVariator = {getRotation(self.variatorAndGear.node)};
			local curRotGearV = {getRotation(self.variatorAndGear.nodeV)};
			local curTransGearH = {getTranslation(self.variatorAndGear.nodeH)};
			
			self.variatorRotMax = self.variatorAndGear.rotMax;
			local move = self.motor.lastMotorRpm > self.motor.minRpm;
			
			if self.isMotorStarted then
				self.variator = self.motor.maxRpm[3] - self.motor.minRpm;
				local variatorCur = (math.abs(self.motor.lastMotorRpm) - self.motor.minRpm) / self.variator;
				if variatorCur > 0.9 then
					variatorCur = 1;
				end;
				local x, y, z = unpack(self.variatorAndGear.rotMax);
				x = x * variatorCur;
				y = y * variatorCur;
				z = z * variatorCur;
				self.variatorRotMax = {x, y, z};
				if self.movingDirection < 0 then
					self.variatorRotMax = self.variatorAndGear.rotMax;
				end;
			end;
			
			local newRot = Utils.getMovedLimitedValues(curRotVariator, self.variatorRotMax, self.variatorAndGear.rotMin, 3, self.variatorAndGear.moveTime, dt, not move);
			setRotation(self.variatorAndGear.node, unpack(newRot));
			
			local VisMax = true;
			local VisNul = true;
			local VisMin = true;
			local HisNul = true;
			
			for i = 1, 3 do
				if math.abs(self.variatorAndGear.rotMaxV[i] - curRotGearV[i]) > 0.001 then
					VisMax = false;
				end;
				if math.abs(self.variatorAndGear.rotNulV[i] - curRotGearV[i]) > 0.001 then
					VisNul = false;
				end;
				if math.abs(self.variatorAndGear.rotMinV[i] - curRotGearV[i]) > 0.001 then
					VisMin = false;
				end;
				if math.abs(self.variatorAndGear.transNulH[i] - curTransGearH[i]) > 0.001 then
					HisNul = false;
				end;
			end;
			
			if self.movingDirection < 0 then
				if (VisNul and HisNul) or (HisNul and self.variatorAndGear.level == 1) then
					self.variatorAndGear.level = -1;
				end;
				self.variatorAndGear.VtoMax = false;
				self.variatorAndGear.VtoMin = true;
				self.variatorAndGear.HtoMax = true;
				self.variatorAndGear.HtoMin = false;
			elseif self.motor.speedLevel == 1 then
				if (VisNul and HisNul) or (HisNul and self.variatorAndGear.level == -1) then
					self.variatorAndGear.level = 1;
				end;
				self.variatorAndGear.VtoMax = false;
				self.variatorAndGear.VtoMin = true;
				self.variatorAndGear.HtoMax = false;
				self.variatorAndGear.HtoMin = true;
				if self.variatorAndGear.level == 3 then
					self.variatorAndGear.HtoMin = false;
				end;
			elseif (self.motor.speedLevel == 2 or self.motor.speedLevel == 4) then
				if (VisNul and HisNul) or (HisNul and self.variatorAndGear.level == 3) then
					self.variatorAndGear.level = 2;
				end;
				self.variatorAndGear.VtoMax = true;
				self.variatorAndGear.VtoMin = false;
				self.variatorAndGear.HtoMax = true;
				self.variatorAndGear.HtoMin = false;
			elseif (self.motor.speedLevel == 3 or (self.motor.speedLevel == 0 and self.movingDirection > 0)) then
				if (VisNul and HisNul) or (HisNul and self.variatorAndGear.level == 2) then
					self.variatorAndGear.level = 3;
				end;
				self.variatorAndGear.VtoMax = true;
				self.variatorAndGear.VtoMin = false;
				self.variatorAndGear.HtoMax = false;
				self.variatorAndGear.HtoMin = true;
				if self.variatorAndGear.level == 1 then
					self.variatorAndGear.HtoMin = false;
				end;
			else
				self.variatorAndGear.VtoMax = false;
				self.variatorAndGear.VtoMin = false;
				self.variatorAndGear.HtoMax = false;
				self.variatorAndGear.HtoMin = false;
			end;
			
			if self.variatorAndGear.level > 1 and HisNul then
				local newRot = Utils.getMovedLimitedValues(curRotGearV, self.variatorAndGear.rotMaxV, self.variatorAndGear.rotNulV, 3, self.variatorAndGear.moveTimeV, dt, not self.variatorAndGear.VtoMax);
				setRotation(self.variatorAndGear.nodeV, unpack(newRot));
			elseif (self.variatorAndGear.level == 1 or self.variatorAndGear.level == -1) and HisNul then
				local newRot = Utils.getMovedLimitedValues(curRotGearV, self.variatorAndGear.rotMinV, self.variatorAndGear.rotNulV, 3, self.variatorAndGear.moveTimeV, dt, not self.variatorAndGear.VtoMin);
				setRotation(self.variatorAndGear.nodeV, unpack(newRot));
			end;
			
			if (self.variatorAndGear.level == -1 and VisMin) or (self.variatorAndGear.level == 2 and VisMax) then
				local newTrans = Utils.getMovedLimitedValues(curTransGearH, self.variatorAndGear.transMaxH, self.variatorAndGear.transNulH, 3, self.variatorAndGear.moveTimeH, dt, not self.variatorAndGear.HtoMax);
				setTranslation(self.variatorAndGear.nodeH, unpack(newTrans));
			elseif (self.variatorAndGear.level == 1 and VisMin) or (self.variatorAndGear.level == 3 and VisMax) then
				local newTrans = Utils.getMovedLimitedValues(curTransGearH, self.variatorAndGear.transMinH, self.variatorAndGear.transNulH, 3, self.variatorAndGear.moveTimeH, dt, not self.variatorAndGear.HtoMin);
				setTranslation(self.variatorAndGear.nodeH, unpack(newTrans));
			end;
		end;
	end;
end;

function E512VariatorAndGear:updateTick(dt)
end;

function E512VariatorAndGear:delete()
end;

function E512VariatorAndGear:readStream(streamId, connection)
end;

function E512VariatorAndGear:writeStream(streamId, connection)
end;

function E512VariatorAndGear:mouseEvent(posX, posY, isDown, isUp, button)
end;

function E512VariatorAndGear:keyEvent(unicode, sym, modifier, isDown)
end;

function E512VariatorAndGear:draw()
end;

function E512VariatorAndGear:onDeactivate()
end;