--
-- animationControl v1.0 BETA
--
-- 05/2013 by Saty / http://forum.lsczech.cz
--

animationControl = {};

function animationControl.prerequisitesPresent(specializations)
    return true;
end;

function animationControl:load(xmlFile)
	self.animationLevers = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.animationControl.part(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local part = {};
		part.node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"));
		part.action = getXMLString(xmlFile, key .. "#action");
		part.autoreturn = Utils.getNoNil(getXMLString(xmlFile, key .. "#autoReturn"), false);
		part.visChange = Utils.getNoNil(getXMLString(xmlFile, key .. "#visChange"), false);
		part.reverse = Utils.getNoNil(getXMLString(xmlFile, key .. "#reverse"), false);
		part.visFrom = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#visFrom"));

		local rotMin = getXMLString(xmlFile, key .. "#rotMin");
		local rotNul = getXMLString(xmlFile, key .. "#rotNul");
		local rotMax = getXMLString(xmlFile, key .. "#rotMax");
		if rotMin ~= nil and rotMax ~= nil then
			local x,y,z = Utils.getVectorFromString(rotMin);
			part.rotMin = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
			local x,y,z = Utils.getVectorFromString(rotMax);
			part.rotMax = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		end;
		if rotNul ~= nil then
			local x,y,z = Utils.getVectorFromString(rotNul);
			part.rotNul = {math.rad(Utils.getNoNil(x,0)),math.rad(Utils.getNoNil(y,0)),math.rad(Utils.getNoNil(z,0))};
		end;
		
		local transMin = getXMLString(xmlFile, key .. "#transMin");
		local transMax = getXMLString(xmlFile, key .. "#transMax");
		if transMin ~= nil and transMax ~= nil then
			local x,y,z = Utils.getVectorFromString(transMin);
			part.transMin = {Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0)};
			local x,y,z = Utils.getVectorFromString(transMax);
			part.transMax = {Utils.getNoNil(x,0),Utils.getNoNil(y,0),Utils.getNoNil(z,0)};
		end;
		
		part.moveTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#moveTime"),1)*1000;
		
		part.move = false;
		part.reset = true;
		part.toMin = false;
		part.toMax = false;
		
		if part.node ~= nil then
			table.insert(self.animationLevers, part);
		end;
		i = i + 1;
	end;
end;

function animationControl:update(dt)
	if self:getIsActive() then
		for _, part in ipairs(self.animationLevers) do
			if part.action == "travelWithZero" then
				if self.movingDirection > 0.5 and part.move ~= "B" then
					part.move = "F";
					part.toMax = true;
					part.toMin = false;
				elseif self.movingDirection < -0.5 and part.move ~= "F" then
					part.move = "B";
					part.toMax = false;
					part.toMin = true;
				else
					part.toMax = false;
					part.toMin = false;
				end;
			elseif part.action == "isLoweredWithZero" then
				local isLowered = false;
				for i=1, table.getn(self.attachedImplements) do
					if self.attachedImplements[i].object:isLowered(false) then
						isLowered = true;
					end;
				end;
				if isLowered then
					if part.reset then
						part.move = "F";
						part.reset = false;
						part.toMax = true;
						part.toMin = false;
					elseif getRotation(part.node) >= unpack(part.rotMax) then
						part.toMax = false;
						part.toMin = false;
					end;
				else
					if not part.reset then
						part.move = "B";
						part.reset = true;
						part.toMax = false;
						part.toMin = true;
					elseif getRotation(part.node) <= unpack(part.rotMin) then
						part.toMax = false;
						part.toMin = false;
					end;
				end;
			elseif part.action == "isLowered" then
				part.rotNul = nil;
				local isLowered = false;
				for i=1, table.getn(self.attachedImplements) do
					if self.attachedImplements[i].object:isLowered(false) then
						isLowered = true;
					end;
				end;
				if isLowered then
					part.move = not part.reverse;
				else
					part.move = part.reverse;
				end;
			elseif part.action == "getVisibility" and part.visFrom ~= nil then
				part.rotNul = nil;
				part.move = getVisibility(part.visFrom);
				if part.reverse then
					part.move = not part.move;
				end;
			elseif part.action ~= nil then
				part.rotNul = nil;
				if self[part.action] then
					if part.reset then
						part.move = not part.reverse;
						part.reset = false;
					end;
				else
					part.move = part.reverse;
					part.reset = true;
				end;
			end;
			
			-- visibility parts--
			if part.visChange then
				setVisibility(part.node, part.move);
			end;
			
			-- rotate animation--
			if part.rotMax ~= nil and part.rotMin ~= nil and part.rotNul ~= nil then
				local curRot = {getRotation(part.node)};
				if unpack(curRot) == unpack(part.rotNul) and not part.toMax and not part.toMin then
					part.move = nil;
				end;
				if part.move == "F" then
					local newRot = Utils.getMovedLimitedValues(curRot, part.rotMax, part.rotNul, 3, part.moveTime, dt, not part.toMax);
					setRotation(part.node, unpack(newRot));
				elseif part.move == "B" then
					local newRot = Utils.getMovedLimitedValues(curRot, part.rotMin, part.rotNul, 3, part.moveTime, dt, not part.toMin);
					setRotation(part.node, unpack(newRot));
				end;
			end;
			
			if part.rotMax ~= nil and part.rotMin ~= nil and part.rotNul == nil then
				local curRot = {getRotation(part.node)};
				if part.autoreturn then
					local isMax = true;
					for i = 1, 3 do
						if math.abs(part.rotMax[i] - curRot[i]) > 0.001 then
							isMax = false;
						end;
					end;
					if isMax then
						part.move = part.reverse;
					end;
				end;
				local newRot = Utils.getMovedLimitedValues(curRot, part.rotMax, part.rotMin, 3, part.moveTime, dt, not part.move);
				setRotation(part.node, unpack(newRot));
			end;
			
			--translate animation --
			if part.transMin ~= nil and part.transMax ~= nil then
				local curTrans = {getTranslation(part.node)};
				if part.autoreturn then
					local isMax = true;
					for i = 1, 3 do
						if math.abs(part.transMax[i] - curTrans[i]) > 0.001 then
							isMax = false;
						end;
					end;
					if isMax then
						part.move = part.reverse;
					end;
				end;
				local newTrans = Utils.getMovedLimitedValues(curTrans, part.transMax, part.transMin, 3, part.moveTime, dt, not part.move);
				setTranslation(part.node, unpack(newTrans));
			end;
		end;
	end;
end;

function animationControl:updateTick(dt)
end;

function animationControl:delete()
end;

function animationControl:readStream(streamId, connection)
end;

function animationControl:writeStream(streamId, connection)
end;

function animationControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function animationControl:keyEvent(unicode, sym, modifier, isDown)
end;

function animationControl:draw()
end;

function animationControl:onDeactivate()
end;