-- by modelleicher
-- www.schwabenmodding.bplaced.net

tracFrontAxle = {};

function tracFrontAxle.prerequisitesPresent(specializations)
    return true;
end;

function tracFrontAxle:load(xmlFile)

	
	self.fl = {}; -- Feder Links
	self.fl.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#index"));
	self.fl.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#scaleRefPunkt"));
	self.fl.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Links#directionRefPunkt"));
	local flax, flay, flaz = getWorldTranslation(self.fl.index);
	local flbx, flby, flbz = getWorldTranslation(self.fl.scaleRefPoint);
	self.fl.scaleDistance = Utils.vector3Length(flax-flbx, flay-flby, flaz-flbz);	
	
	self.fr = {}; -- Feder Rechts
	self.fr.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#index"));
	self.fr.scaleRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#scaleRefPunkt"));
	self.fr.dirRefPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tracFrontAchse.Federn.Rechts#directionRefPunkt"));
	local frax, fray, fraz = getWorldTranslation(self.fr.index);
	local frbx, frby, frbz = getWorldTranslation(self.fr.scaleRefPoint);
	self.fr.scaleDistance = Utils.vector3Length(frax-frbx, fray-frby, fraz-frbz);	
	

	
end;
function tracFrontAxle:delete()
end;
function tracFrontAxle:mouseEvent(posX, posY, isDown, isUp, button)
end;
function tracFrontAxle:keyEvent(unicode, sym, modifier, isDown)
end;

function tracFrontAxle:update(dt)
	if self:getIsActive() then

		
		-- Animation der Federn
		if self.fl.index ~= nil then
			local ax, ay, az = getWorldTranslation(self.fl.index);
			local bx, by, bz = getWorldTranslation(self.fl.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.fl.index), bx-ax, by-ay, bz-az);
			setDirection(self.fl.index, x, y, z, 0, 0, 1);			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			local scaleX, scaleY, scaleZ = getScale(self.fl.index);
			local setScaleWert = scaleZ * (distance / self.fl.scaleDistance);
			setScale(self.fl.index, 1, 1, setScaleWert);	
		end;
		if self.fr.index ~= nil then
			local ax, ay, az = getWorldTranslation(self.fr.index);
			local bx, by, bz = getWorldTranslation(self.fr.dirRefPoint);
			x, y, z = worldDirectionToLocal(getParent(self.fr.index), bx-ax, by-ay, bz-az);
			setDirection(self.fr.index, x, y, z, 0, 0, 1);			
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			local scaleX, scaleY, scaleZ = getScale(self.fr.index);
			local setScaleWert = scaleZ * (distance / self.fr.scaleDistance);
			setScale(self.fr.index, 1, 1, setScaleWert);	
		end;	


	end;
end;

function tracFrontAxle:draw()	

end;
