SetWorkLightEvent = {};
SetWorkLightEvent_mt = Class(SetWorkLightEvent, Event);

InitEventClass(SetWorkLightEvent, "SetWorkLightEvent");

function SetWorkLightEvent:emptyNew()
      local self = Event:new(SetWorkLightEvent_mt);
      self.className="SetWorkLightEvent";
      return self;
end;

function SetWorkLightEvent:new(object, active)
      local self = SetWorkLightEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetWorkLightEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetWorkLightEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetWorkLightEvent:run(connection)
      self.object:setWorkLightsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetWorkLightEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;