-- By PeterJ (26-03-2011)



Wheels = {};

function Wheels.prerequisitesPresent(specializations)
    return true;
end;
function Wheels:load(xmlFile)

	self.setDWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDWheelsVisibility");

    self.DWheels = {};
        local i = 0;
        while true do
        local key = string.format("vehicle.DWheels.DWheel(%d)", i);
            if not hasXMLProperty(xmlFile, key) then
             break;
        end;
            local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
            if node ~= nil then
        setVisibility(node, false);
            table.insert(self.DWheels, {node=node});
        end;
        i = i + 1;
        end;

end;
function Wheels:delete()
end;
function Wheels:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setDWheelsVisibility(visibility, true);

end;

function Wheels:writeStream(streamId, connection)
	streamWriteBool(streamId, self.DWheelsActive);

end;

function Wheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Wheels:keyEvent(unicode, sym, modifier, isDown)
end;

function Wheels:update(dt)

    if self:getIsActiveForInput() and self.isClient then
        if InputBinding.hasEvent(InputBinding.USWHEEL) then
              self:setDWheelsVisibility(not self.DWheelsActive);
        end;
    end;
end;

function Wheels:onLeave()
end;

function Wheels:draw()
end;

function Wheels:setDWheelsVisibility(visibility, noEventSend)
    if visibility ~= self.DWheelsActive then

        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetDWheelsEvent:new(self, visibility), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(SetDWheelsEvent:new(self, visibility));
            end;
        end;

        self.DWheelsActive = visibility;

        for _, DWheel in pairs(self.DWheels) do
            setVisibility(DWheel.node, visibility);
        end;
        for _,v in pairs(self.specializations) do
            if v.setDWheelVisibility ~= nil then
                v.setDWheelVisibility(self, visibility);
            end;
        end;
    end;
end;


SetDWheelsEvent = {};
SetDWheelsEvent_mt = Class(SetDWheelsEvent, Event);
InitEventClass(SetDWheelsEvent, "SetDWheelsEvent");
function SetDWheelsEvent:emptyNew()
      local self = Event:new(SetDWheelsEvent_mt);
      self.className="SetDWheelsEvent";
      return self;
end;
function SetDWheelsEvent:new(object, active)
      local self = SetDWheelsEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function SetDWheelsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function SetDWheelsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function SetDWheelsEvent:run(connection)
      self.object:setDWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDWheelsEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;