-- Script para Colheitadeiras
-- AnimatedPolias
-- author: Burner
-- Edio: Vinicius LS---FBT Modding
-- Anotao como instalar
-- Modesc Files:

-- 	<specializations>
--		<specialization name="AnimatedPolias" 	className="AnimatedPolias" 	filename="AnimatedPolias.lua" />	
--  </specializations>

--	<vehicleTypes>
--	<specialization name="AnimatedPolias" />
--	</vehicleTypes>

--XML Mod Files:

--		<rolls>
--		<roll index="0>38|28|0" speed="-0.99"/>
--		<roll index="0>38|28|1" speed="-0.99"/>
--		<roll index="0>38|28|2" speed="-0.99"/>
--   	</rolls>
--End--
AnimatedPolias = {};

function AnimatedPolias.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AnimatedPolias:load(xmlFile)
	
	self.rollNodes = {};
	
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
end;

function AnimatedPolias:readStream(streamId, connection)
end;

function AnimatedPolias:writeStream(streamId, connection)
end;

function AnimatedPolias:delete()
end;

function AnimatedPolias:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedPolias:keyEvent(unicode, sym, modifier, isDown)
end;
 
function AnimatedPolias:update(dt)
	if self.isThreshing then
		for _, rollNode in pairs(self.rollNodes) do
			rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
	end;
end;

function AnimatedPolias:onLeave()
end;

function AnimatedPolias:draw()
end;

		end;
	end;