--
-- OilChange
-- Specialization for changing oil
--
-- @author	JoXXer
-- @date  	16/11/11
--

OilChange = {};

function OilChange.prerequisitesPresent(specializations)
    return true;
end;

function OilChange:load(xmlFile)

	self.changeOil = SpecializationUtil.callSpecializationsFunction("changeOil");

	self.oilChange = {};
	self.oilChange.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.oilChange#oilChangeCheckString"), "OilChange");
	self.oilChange.oilInRange = nil;

	self.oilLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardOil#index"));

	self.shouldChangeOil = false;
	self.nextOilChange = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.oilChange#firstOilChange"), 3600)
	self.oilChangeInterval = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.oilChange#interval"), 3600)

	self.checkOilOverlay = Overlay:new("hudcheckOilOverlay", Utils.getFilename("Textures/CheckEngineOil.png", self.baseDirectory), 0.925, 0.55, 0.03125, 0.05);
end;

function OilChange:delete()

end;

function OilChange:readStream(streamId, connection)
    self.shouldChangeOil = streamReadBool(streamId);
    self.nextOilChange = streamReadInt32(streamId);
end;

function OilChange:writeStream(streamId, connection)
    streamWriteBool(streamId, self.shouldChangeOil);
    streamWriteInt32(streamId, self.nextOilChange);
end;

function OilChange:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OilChange:keyEvent(unicode, sym, modifier, isDown)
end;

function OilChange:update(dt)
	if self:getIsActive() then

		local oilChange = self.oilChange;
		local oilWarning = (self.nextOilChange * 1000) * 0.9;

		if oilChange.oilInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CHANGE_OIL) then
					if oilWarning < self.operatingTime and oilChange.oilInRange.oilCapacity >= 50 then
						oilChange.oilInRange:changeOil(self);
					end;
				end;
				if oilChange.oilInRange.oilCapacity == 0 then
					g_currentMission:addWarning(g_i18n:getText("Out_Of_Oil") .. "\n" .. g_i18n:getText("Buy_More_Oil"));
				end;
			end;
		end;

		if self.shouldChangeOil == false and self.operatingTime > (self.nextOilChange * 1000) then
			self.shouldChangeOil = true;
		end;
		if self.shouldChangeOil then
			self:stopMotor(0);
		end;

		if self.isMotorStarted then
			if oilWarning < self.operatingTime then
				setVisibility(self.oilLight, true);
			else
				setVisibility(self.oilLight, false);
			end;
		end;
		if self.ignitionMode == 0 and self.ignitionMode ~= nil then
			setVisibility(self.oilLight, false)
		end;
	end;
end;

function OilChange:draw()
	local oilChange = self.oilChange;
	local oilWarning = (self.nextOilChange * 1000) * 0.9;

	if oilChange.oilInRange ~= nil then
		if oilWarning < self.operatingTime then
			g_currentMission:addHelpButtonText(g_i18n:getText("CHANGE_OIL"), InputBinding.CHANGE_OIL);

		end;
	end;

	if oilWarning < self.operatingTime then
		self.checkOilOverlay:render();
	end;

	if self.shouldChangeOil then
		g_currentMission:addWarning(g_i18n:getText("Oil_Change_Iminent") .. "\n" .. g_i18n:getText("Change_The_Oil"));
	end;

end;

function OilChange:changeOil(oilChange)
	if oilChange.oilPalletVehicle ~= nil then
		oilChange.oilCapacity = oilChange.oilCapacity - 50;
		self.shouldChangeOil = false;
		self.nextOilChange = self.nextOilChange + self.oilChangeInterval;
	end;
end;

function OilChange:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueInt = getXMLInt(xmlFile, key.."#nextOilChange");
		if valueInt ~= nil then
			self.nextOilChange = valueInt;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function OilChange:getSaveAttributesAndNodes(nodeIdent)
	local attributes = nil;

	attributes = 'nextOilChange="'.. self.nextOilChange .. '"';

	return attributes, nil;
end;

