--
-- hydraulicPipes
-- Specialization for hydraulic pipes
--
-- @author  Stefan Maurus	
-- @date  06/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

--[[
	<pipes attached="" deAttached="">
		<bones activ="true" mesh=""/>
		<animation activ="true" refNode="" refMinRot="" refMaxRot="" refMinTrans="" refMaxTrans="" refAxis="" rootNode="" clip="" />
	</pipes>
]]

hydraulicPipes = {};

function hydraulicPipes.prerequisitesPresent(specializations)
    return true;
end;

function hydraulicPipes:load(xmlFile)		
	self.hasAnimation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.pipes.animation#activ"), false);	
	if self.hasAnimation then
		self.refNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes.animation#refNode")); 		
		self.refMinRot = getXMLFloat(xmlFile, "vehicle.pipes.animation#refMinRot");
		self.refMaxRot = getXMLFloat(xmlFile, "vehicle.pipes.animation#refMaxRot");
		if self.refMinRot == nil and self.refMaxRot == nil then
			self.refMinTrans = getXMLFloat(xmlFile, "vehicle.pipes.animation#refMinTrans");
			self.refMaxTrans = getXMLFloat(xmlFile, "vehicle.pipes.animation#refMaxTrans");
			self.refTrans = true;
			self.refRot = false;
		else
			self.refRot = true;	
			self.refTrans = false;			
		end;
		self.refAxis = getXMLFloat(xmlFile, "vehicle.pipes.animation#refAxis");
		
		self.animatedPipes = {};
		self.animatedPipes.animCharSet = 0;
		self.animatedPipesEnabled = false;
		self.animatedPipesFactor = 0;
		
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes.animation#rootNode"));
	  
		if rootNode ~= nil then
			self.animatedPipes.animCharSet = getAnimCharacterSet(rootNode);
			if self.animatedPipes.animCharSet ~= 0 then
				self.animatedPipes.clip = getAnimClipIndex(self.animatedPipes.animCharSet, getXMLString(xmlFile, "vehicle.pipes.animation#clip"));
				if self.animatedPipes.clip >= 0 then
					assignAnimTrackClip(self.animatedPipes.animCharSet, 0, self.animatedPipes.clip);
					setAnimTrackSpeedScale(self.animatedPipes.animCharSet, self.animatedPipes.clip, 0);
					setAnimTrackLoopState(self.animatedPipes.animCharSet, 0, false);
				end;
			end;
		end;	
	end;
	
    self.deAttachedPipes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes#deAttached"));
    self.attachedPipes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes#attached")); 
	setVisibility(self.attachedPipes, false);
	setVisibility(self.deAttachedPipes, true);
	
	self.hasBonesMesh = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.pipes.bones#activ"), false);
	if self.hasBonesMesh then
		self.bonesMesh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipes.bones#mesh"));
		link(getRootNode(),self.bonesMesh);
		setTranslation(self.bonesMesh,0,0,0);
		setRotation(self.bonesMesh,0,0,0);
	end;	
end;

function hydraulicPipes:delete()
	if self.hasBonesMesh then
		delete(self.bonesMesh);
	end;
end;

function hydraulicPipes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hydraulicPipes:keyEvent(unicode, sym, modifier, isDown)
end;

function hydraulicPipes:update(dt)
	if self.hasAnimation then
		if not self.animatedPipesEnabled then
			enableAnimTrack(self.animatedPipes.animCharSet, 0);
			self.animatedPipesEnabled = true;
		end;
		
		if self.refRot then
			local x, y, z = getRotation(self.refNode);
			if self.refAxis == 1 then
				self.animatedPipesFactor = (math.deg(x)-self.refMinRot) / (self.refMaxRot-self.refMinRot);
			elseif self.refAxis == 2 then
				self.animatedPipesFactor = (math.deg(y)-self.refMinRot) / (self.refMaxRot-self.refMinRot);
			elseif self.refAxis == 3 then
				self.animatedPipesFactor = (math.deg(z)-self.refMinRot) / (self.refMaxRot-self.refMinRot);
			end;
		elseif self.refTrans then
			local x, y, z = getTranslation(self.refNode);
			if self.refAxis == 1 then
				self.animatedPipesFactor = (x-self.refMinTrans) / (self.refMaxTrans-self.refMinTrans);
			elseif self.refAxis == 2 then
				self.animatedPipesFactor = (y-self.refMinTrans) / (self.refMaxTrans-self.refMinTrans);
			elseif self.refAxis == 3 then
				self.animatedPipesFactor = (z-self.refMinTrans) / (self.refMaxTrans-self.refMinTrans);
			end;			
		end;
		
		local duration = getAnimClipDuration(self.animatedPipes.animCharSet, self.animatedPipes.clip)
		setAnimTrackTime(self.animatedPipes.animCharSet, 0, duration*self.animatedPipesFactor, true);	
		
		if self.animatedPipesEnabled then
			disableAnimTrack(self.animatedPipes.animCharSet, 0);
			self.animatedPipesEnabled = false;
		end;	
	end;
end;

function hydraulicPipes:updateTick(dt)
 end;

function hydraulicPipes:onAttach()	
	setVisibility(self.attachedPipes, true);
	setVisibility(self.deAttachedPipes, false);	
end;

function hydraulicPipes:onDetach()	
	setVisibility(self.attachedPipes, false);
	setVisibility(self.deAttachedPipes, true);	
end;

function hydraulicPipes:draw()
end;