-- ControlDynamicMountAttacher
-- 
--
-- author: fruktor
-- www.eifok-team.de
-- 

ControlDynamicMountAttacher = {};


function ControlDynamicMountAttacher.prerequisitesPresent(specializations)
	if not SpecializationUtil.hasSpecialization(DynamicMountAttacher, specializations) then
		print("[ControlDynamicMountAttacher]::WARNING:: This script needs the specialization DynamicMountAttacher!");
	end;
    return SpecializationUtil.hasSpecialization(DynamicMountAttacher, specializations);
end;

function ControlDynamicMountAttacher:load(xmlFile)	

	self.setReleaseBales = SpecializationUtil.callSpecializationsFunction("setReleaseBales");
	
	self.doReleaseBales = true;
	
	self.rotSpeed1Backup = self.movingTools[1].rotSpeed;
	self.transSpeed1Backup = self.movingTools[1].transSpeed;
	self.rotSpeed2Backup = self.movingTools[2].rotSpeed;
	self.transSpeed2Backup = self.movingTools[2].transSpeed;	
end;

function ControlDynamicMountAttacher:delete()
end;

function ControlDynamicMountAttacher:readStream(streamId, connection)

end;

function ControlDynamicMountAttacher:writeStream(streamId, connection)	

end;

function ControlDynamicMountAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ControlDynamicMountAttacher:keyEvent(unicode, sym, modifier, isDown)

end;

function ControlDynamicMountAttacher:update(dt)
		
	--###
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.ALOE_BALEATTACH) then
				self:setReleaseBales(not self.doReleaseBales);
			end
		end
	end	
	
	--# dis-/enable automatic attaching
	if self.isServer then
		if self.doReleaseBales == true then 		
			self.movingTools[1].rotSpeed = self.rotSpeed1Backup;
			self.movingTools[1].transSpeed = self.transSpeed1Backup;		
			self.movingTools[2].rotSpeed = self.rotSpeed2Backup;
			self.movingTools[2].transSpeed = self.transSpeed2Backup;					
			for object,i in pairs(self.dynamicMountedObjects) do
				if object ~= nil then
					--print("releasing: "..tostring(object));
					self:removeDynamicMountedObject(object, false);
					object:unmountDynamic();
				end;
			end			
			
		else 
			self.movingTools[1].rotSpeed = 0;
			self.movingTools[1].transSpeed = 0;		
			self.movingTools[2].rotSpeed = 0;
			self.movingTools[2].transSpeed = 0;	
			for object,_ in pairs(self.pendingDynamicMountObjects) do
				if self.dynamicMountedObjects[object] == nil then
					--print("attaching: "..tostring(object));
					if object:mountDynamic(self, self.dynamicMountAttacherTrigger.rootNode, self.dynamicMountAttacherTrigger.jointNode, false, self.dynamicMountAttacherTrigger.forceLimitScale) then
						self:addDynamicMountedObject(object);
					end				
				end
			end;
			
		end		
	end

	--# 
    if self.isServer then
		if self.doReleaseBales == true then
			-- overwrite bale time every frame -> DynMountAttacher does not attach, we do it here @ few lines above
			for object,_ in pairs(self.pendingDynamicMountObjects) do
				object.lastMoveTime = g_currentMission.time;
				--if self.dynamicMountedObjects[object] == nil then
				--end;
			end;
		end;
	end;
	
end;


function ControlDynamicMountAttacher:updateTick(dt)
				
end;

function ControlDynamicMountAttacher:draw()
	if self.doReleaseBales == true then
		g_currentMission:addHelpButtonText( g_i18n:getText("ALOE_BALEATTACH"), InputBinding.ALOE_BALEATTACH);	
	else
		g_currentMission:addHelpButtonText( g_i18n:getText("ALOE_BALERELEASE"), InputBinding.ALOE_BALEATTACH);	
	end
end;

function ControlDynamicMountAttacher:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ControlDynamicMountAttacher:getSaveAttributesAndNodes(nodeIdent)
    local attributes = '';
    return attributes, nil;
end;

function ControlDynamicMountAttacher:onAttach(attacherVehicle)
end;

function ControlDynamicMountAttacher:onDetach()
end;


--###
function ControlDynamicMountAttacher:setReleaseBales(state, noEventSend)	
	SetReleaseBalesEvent.sendEvent(self, state, noEventSend);
	self.doReleaseBales = state;	
end;




--------------------------------------------------------------------------------------
--
--
--
--
--
SetReleaseBalesEvent = {};
SetReleaseBalesEvent_mt = Class(SetReleaseBalesEvent, Event);

InitEventClass(SetReleaseBalesEvent, "SetReleaseBalesEvent");

function SetReleaseBalesEvent:emptyNew()
    local self = Event:new(SetReleaseBalesEvent_mt);
    self.className="SetReleaseBalesEvent";
    return self;
end;

function SetReleaseBalesEvent:new(vehicle, state)
    local self = SetReleaseBalesEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetReleaseBalesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetReleaseBalesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetReleaseBalesEvent:run(connection)
	self.vehicle:setReleaseBales(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetReleaseBalesEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetReleaseBalesEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetReleaseBalesEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetReleaseBalesEvent:new(vehicle, state));
		end;
	end;
end;