--
-- JD_Trailer
-- 
--
-- @author  MySQly
-- @date  15/01/10
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

JD_Trailer = {}

function JD_Trailer.prerequisitesPresent(specializations)
		Vehicle.registerJointType("cutter");
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function JD_Trailer:load(xmlFile)
	self.Kier_L = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Kier_L#index"));
	self.Kier_P = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Kier_P#index"));

	local rotationNodeSupport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationSupport#index"));
    if rotationNodeSupport ~= nil then
        self.rotationSupport = {};
        self.rotationSupport.node = rotationNodeSupport;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSupport#minRot"));
        self.rotationSupport.minRot = {};
        self.rotationSupport.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSupport.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSupport.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSupport#maxRot"));
        self.rotationSupport.maxRot = {};
        self.rotationSupport.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSupport.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSupport.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSupport.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSupport#rotTime"), 2)*1000;
        self.rotationSupport.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSupport#touchRotLimit"), 10));
    end; 	
	
end;
function JD_Trailer:update(dt)
	if self.attacherVehicle ~= nil then
		setVisibility(self.Kier_L, self.attacherVehicle.worklightsActive);
		setVisibility(self.Kier_P, self.attacherVehicle.worklightsActive2);
	else
		setVisibility(self.Kier_L, false);
		setVisibility(self.Kier_P, false);
	end;
	
	local doRotate = self.rotationSupportMax or self.rotationSupportMin 
	if self.rotationSupport ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSupport.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSupport.maxRot, self.rotationSupport.minRot, 3, self.rotationSupport.rotTime, dt, not self.rotationSupportMax);
        setRotation(self.rotationSupport.node, unpack(newRot));
    end;	

end;
function JD_Trailer:keyEvent(unicode, sym, modifier, isDown)

end;
function JD_Trailer:mouseEvent(posX, posY, isDown, isUp, button)

end;
function JD_Trailer:delete()

end;

function JD_Trailer:draw()
	if self.attacherVehicle ~= nil then
		g_currentMission:addExtraPrintText("Shift + Q - to detach");
	end;
end;

function JD_Trailer:onDetach()
	for i=table.getn(self.attachedImplements), 1, -1 do
		self:detachImplement(1);
    end;
	self.rotationSupportMin = true;
	self.rotationSupportMax = false;
end;

function JD_Trailer:onAttach()
		self.rotationSupportMin = false;
		self.rotationSupportMax = true;
end;