--
-- gravityWagon
-- This is the specialization for gravity wagon
--
-- @author  PeterJ - euroDZN
-- @date  19/10/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.


gravityWagon = {};

function gravityWagon.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function gravityWagon:load(xmlFile)

	self.onDeactivate = Utils.overwrittenFunction(self.onDeactivate, gravityWagon.onDeactivate)
	self.updateSteeringAxleAngle = false;
	self.wagonSteeringAxle = true;
	
	self.steerFrame = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steerFrame#index"));
	
	self.hatchLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hatchLight#index"));
	
end;
	
function gravityWagon:delete()
end;

function gravityWagon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function gravityWagon:keyEvent(unicode, sym, modifier, isDown)
end;

function gravityWagon:update(dt)

	if self.steerFrame ~= nil then
		if self.wagonSteeringAxle then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.components[2].node, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			self.steeringAxleAngle = angle;
			
			local x,y,z = getRotation(self.wheels[1].repr);	
			setRotation(self.steerFrame, 0, y, 0);
		end;
	end;

	if self.tipState == Trailer.TIPSTATE_OPENING then
		setVisibility(self.hatchLight, true);
	elseif self.tipState == Trailer.TIPSTATE_CLOSED then
		setVisibility(self.hatchLight, false);
	end;
end;

function gravityWagon:draw()
end;

function gravityWagon:onDeactivate()
	self:onBrake(true);

	self:setLightsTypesMask(0, true);
	self:setBeaconLightsVisibility(false, true);
end;