--
-- EinzugsPS
-- Start seperate PS for Cutter when activ
--
-- Ersteller: Brndi
-- 
-- Datum 11/01/13
--

EinzugPS = {};

function EinzugPS.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function EinzugPS:load(xmlFile)
	
	if self.isClient then
		self.extraParticleSystems = {};
		local i=0;
		while true do
			local key = string.format("vehicle.extraParticleSystems.extraParticleSystem(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local extraParticleSystem = {};
				extraParticleSystem.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, extraParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
				table.insert(self.extraParticleSystems, extraParticleSystem);
			end;
			i = i+1;
		end;
	end;
	
end;

function EinzugPS:delete()
	for k, extraParticleSystem in pairs(self.extraParticleSystems) do
		Utils.deleteParticleSystem(extraParticleSystem);
	end;
end;

function EinzugPS:readStream(streamId, connection)
end;

function EinzugPS:writeStream(streamId, connection)
end;

function EinzugPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function EinzugPS:keyEvent(unicode, sym, modifier, isDown)
end;

function EinzugPS:update(dt)

	if self.currentPipeParticleSystem then
		for k, extraParticleSystem in pairs(self.extraParticleSystems) do
			Utils.setEmittingState(extraParticleSystem.particleSystem, true);
		end;
	else
		for k, extraParticleSystem in pairs(self.extraParticleSystems) do
			Utils.setEmittingState(extraParticleSystem.particleSystem, false);
		end;
	end;
	
end;

function EinzugPS:updateTick(dt)
end;

function EinzugPS:draw()
end;