--
-- self
-- for all self
--
-- @author by Boembchen
-- @date  27/10/10
--
-- Copyright (C) 

anim = {};

function anim .prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function anim:load(xmlFile)

   
	
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	self.engineRunTime = 0;
	self.updateJoint = false;
end;

function anim:keyEvent(unicode, sym, modifier, isDown)
end;


function anim:update(dt)

	Cylindered.updateMovingPart(self, self.movingParts[1]);
end;	
function anim:updateTick(dt)

    if self:getIsActive() then	
		
		
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
		
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;
		
  

function anim:draw()
end;

function anim:onEnter()  
end;

function anim:onLeave()   
end;

function anim:delete() 
end;

function anim:mouseEvent(posX, posY, isDown, isUp, button)
end;