--
--
-- UrScript edit hummel (modhoster.de)
  
-- Hydraulischer Oberlenker by Avenzio (www.Modding-Stage.com)
--
-- 20.02.2012
--
--
oberlenker = {};

function oberlenker.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function oberlenker:load(xmlFile)
	self.setyAttacher3= SpecializationUtil.callSpecializationsFunction("setyAttacher3");
	self.oberlenker = {};
	self.oberlenker.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.oberlenker#index"));
	self.oberlenker.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.oberlenker#maxY"), 0); 
	self.oberlenker.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.oberlenker#minY"), 0); 
	
	if self.oberlenker ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getRotation(self.oberlenker.index);
		self.yAttacher = yAttacher
	end
	
end;

function oberlenker:delete()
end;

function oberlenker:mouseEvent(posX, posY, isDown, isUp, button)
end;

function oberlenker:keyEvent(unicode, sym, modifier, isDown)

end;

function oberlenker:update(dt)

	if self.oberlenker ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getRotation(self.oberlenker.index);
		local maxY = self.oberlenker.max;
		local minY = self.oberlenker.min;
		local moveSpeed = 0.004;
		
			if InputBinding.isPressed(InputBinding.OBERLENKER_RAUS) and self:getIsActiveForInput() then
					
				if self.yAttacher < maxY then
					self.yAttacher = yAttacher + moveSpeed;
				else
					self.yAttacher = maxY;
				end;
				   self:setyAttacher3(self.yAttacher);
			elseif InputBinding.isPressed(InputBinding.OBERLENKER_REIN) and self:getIsActiveForInput() then
				if self.yAttacher > minY then
					self.yAttacher = yAttacher - moveSpeed;
				else
					self.yAttacher = minY;
				end;
				   self:setyAttacher3(self.yAttacher);
			end;
	end;
				
end;

function oberlenker:setyAttacher3(value, noEventSend)
  local xAttacher, yAttacher, zAttacher = getRotation(self.oberlenker.index);
  oberlenkerEvent.sendEvent(self, value, noEventSend);
  self.yAttacher = value
  
  setRotation(self.oberlenker.index, xAttacher, self.yAttacher, zAttacher);
  
end

function oberlenker:readStream(streamId, connection)


	self.yAttacher = streamReadFloat32(streamId);	

end;

function oberlenker:writeStream(streamId, connection)

	streamWriteFloat32(streamId, self.yAttacher);

end;


function oberlenker:onLeave()
	oberlenkerEvent.sendEvent(self, self.yAttacher);
end;

function oberlenker:draw()

end;

function oberlenker:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

oberlenkerEvent = {};
moveAttacherEvent_mt = Class(oberlenkerEvent, Event);

InitEventClass(oberlenkerEvent, "oberlenkerEvent");

function oberlenkerEvent:emptyNew()
    local self = Event:new(moveAttacherEvent_mt);
    self.className="oberlenkerEvent";
    return self;
end;

function oberlenkerEvent:new(object, data)
    local self = oberlenkerEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function oberlenkerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);	
	self.data = streamReadFloat32(streamId);
	self:run(connection);
end;

function oberlenkerEvent:run(connection)
    self.object:setyAttacher3(self.data , true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(oberlenkerEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function oberlenkerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.data);
end;

              
function oberlenkerEvent.sendEvent(vehicle, data, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(oberlenkerEvent:new(vehicle, data), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(oberlenkerEvent:new(vehicle, data));
		end;
	end
end;



