--edit hummel (modhoster.de)
moveAttacher = {};

function moveAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveAttacher:load(xmlFile)
	self.setyAttacher= SpecializationUtil.callSpecializationsFunction("setyAttacher");
	self.moveableAttacher = {};
	self.moveableAttacher.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacher#index"));
	self.moveableAttacher.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#maxY"), 0); 
	self.moveableAttacher.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher#minY"), 0); 
	
	if self.moveableAttacher ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher.index);
		self.yAttacher = yAttacher
	end
	
end;

function moveAttacher:delete()
end;

function moveAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveAttacher:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttacher:update(dt)

	if self.moveableAttacher ~= nil then
	
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher.index);
		local maxY = self.moveableAttacher.max;
		local minY = self.moveableAttacher.min;
		local moveSpeed = 0.004;
		
			if InputBinding.isPressed(InputBinding.ATTACHER_OP) and self:getIsActiveForInput() then
					
				if self.yAttacher < maxY then
					self.yAttacher = yAttacher + moveSpeed;
				else
					self.yAttacher = maxY;
				end;
				   self:setyAttacher(self.yAttacher);
			elseif InputBinding.isPressed(InputBinding.ATTACHER_NED) and self:getIsActiveForInput() then
				if self.yAttacher > minY then
					self.yAttacher = yAttacher - moveSpeed;
				else
					self.yAttacher = minY;
				end;
				   self:setyAttacher(self.yAttacher);
			end;
	end;
				
end;

function moveAttacher:setyAttacher(value, noEventSend)
  local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher.index);
  moveAttacherEvent.sendEvent(self, value, noEventSend);
  self.yAttacher = value
  
  setTranslation(self.moveableAttacher.index, xAttacher, self.yAttacher, zAttacher);
  
end

function moveAttacher:readStream(streamId, connection)


	self.yAttacher = streamReadFloat32(streamId);	

end;

function moveAttacher:writeStream(streamId, connection)

	streamWriteFloat32(streamId, self.yAttacher);

end;


function moveAttacher:onLeave()
	moveAttacherEvent.sendEvent(self, self.yAttacher);
end;

function moveAttacher:draw()

end;

function moveAttacher:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

moveAttacherEvent = {};
moveAttacherEvent_mt = Class(moveAttacherEvent, Event);

InitEventClass(moveAttacherEvent, "moveAttacherEvent");

function moveAttacherEvent:emptyNew()
    local self = Event:new(moveAttacherEvent_mt);
    self.className="moveAttacherEvent";
    return self;
end;

function moveAttacherEvent:new(object, data)
    local self = moveAttacherEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function moveAttacherEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);	
	self.data = streamReadFloat32(streamId);
	self:run(connection);
end;

function moveAttacherEvent:run(connection)
    self.object:setyAttacher(self.data , true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(moveAttacherEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function moveAttacherEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.data);
end;

              
function moveAttacherEvent.sendEvent(vehicle, data, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(moveAttacherEvent:new(vehicle, data), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(moveAttacherEvent:new(vehicle, data));
		end;
	end
end;



