--
-- John deere 8530
-- Specialization class for John deere 8530
--
-- @author  Michaelbjerg21978
-- @date  19/4!2012
-- Copyright (C) Michaelbjerg21978, All Rights Reserved.

jd8530 = {};

function jd8530.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function jd8530:load(xmlFile)
	
	self.doorIObject = nil;
	self.updateFuelIndicators = SpecializationUtil.callSpecializationsFunction("updateFuelIndicators");
	self.ledriserva = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 100;
	self.prevousFuelPercentage = 0;
    self.handbrake = true;
	self.cos = 20000;
	self.druckLevel = 10000; 
	--HandBrake
	self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
    self.brakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brakelight#index"));
	self.reverselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reverselight#index"));
	      
	--Hydraulic--
	self.frontAttacherJoint = {};
	self.frontAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#front"));
	
	handbrakeSoundFile = Utils.getFilename("sounds/handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("sound/handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("sounds/brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("sound/brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("sounds/brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("sound/brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
		
	compressorSoundFile = Utils.getFilename("sounds/compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("sound/compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("sounds/compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("sound/compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
    
	-- Front wiper animation
	local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperFront#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
        end;
    end;

	self.isWiperFrontActive = false;
	self.finishWiperFront = true;
	self.wiperFrontOn = false;
	self.wiperBackOn = false;

	------Pedali------
	local PedaleGasNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PedaleGas#index"));
    if PedaleGasNode ~= nil then
        self.PedaleGas = {};
        self.PedaleGas.node = PedaleGasNode;    
		self.PedaleGas.maxSpeed = getXMLInt(xmlFile, "vehicle.PedaleGas#maxSpeed");
		local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PedaleGas#minRot"));
		local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PedaleGas#maxRot"));		
		self.PedaleGas.rotMin = {math.rad(Utils.getNoNil(x1,0)),math.rad(Utils.getNoNil(y1,0)),math.rad(Utils.getNoNil(z1,0))};
		self.PedaleGas.rotMax = {math.rad(Utils.getNoNil(x2,0)),math.rad(Utils.getNoNil(y2,0)),math.rad(Utils.getNoNil(z2,0))};
    end;
	
    local PedaleFrenoNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PedaleFreno#index"));
    if PedaleFrenoNode ~= nil then
        self.PedaleFreno = {};
        self.PedaleFreno.node = PedaleFrenoNode;
		local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PedaleGas#minRot"));
		local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.PedaleGas#maxRot"));
		self.PedaleFreno.rotMin = {math.rad(Utils.getNoNil(x1,0)),math.rad(Utils.getNoNil(y1,0)),math.rad(Utils.getNoNil(z1,0))};			
		self.PedaleFreno.rotMax = {math.rad(Utils.getNoNil(x2,0)),math.rad(Utils.getNoNil(y2,0)),math.rad(Utils.getNoNil(z2,0))};
        self.PedaleFreno.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.PedaleFreno#rotTime"), 1)*1000;
        self.PedaleFrenoIsActive = false;
    end;	

	----led---
	self.batteriaicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batteriaicona#index")); 
	self.olioicona = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.olioicona#index")); 
	
	-- Switches
	self.numSwitches = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.switches#count"),0);
	self.switch = {};
	for i=1, self.numSwitches do
		local objname = string.format("vehicle.switches.switch" .. "%d", i);
		self.switch[i] = {};
		self.switch[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
	end;
	
	-- Gasolio indicatori---
	self.fuelIndicatorsGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicators#index"));

	self.numFuelIndicators = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicators#count"), 0);
	self.fuelIndicators = {};
    for i=1, self.numFuelIndicators do
        local objname = string.format("vehicle.fuelIndicators.fuelIndicator" .. "%d", i);
		self.fuelIndicators[i] = {};
        self.fuelIndicators[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.fuelIndicators[i].rotNode,true);
    end;
	
    -- Leve ---
	self.levaindicatori = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.levaindicatori#index"));
    
    --Power Shaft--
	local i=0;
    while true do
        local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;		
		local joint = self.attacherJoints[i+1];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
		i = i + 1;
	end;

	local attacherJointCount = i;
	i = 0;
    while true do
        local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
		
		local joint = self.attacherJoints[attacherJointCount + 1 + i];
		local shaftAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#shaft"));
		if shaftAttacher ~= nil then
			joint.powerShaftAttacher = shaftAttacher;
		end;
        i = i+1;
    end;
	
	---sound riserva---
    fuelwarningSoundFile = Utils.getFilename("sounds/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;


	self.helpPanel = false;
	self.helpPanel = false;
end;

function jd8530:stopMotor()
 self.motor.minRpm = 100;   
end;

function jd8530:delete()

end;

function jd8530:readStream(streamId, connection)

end;

function jd8530:writeStream(streamId, connection)

end;

function jd8530:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if streamReadBool(streamId) then
		end;
	end;
end;

function jd8530:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if streamWriteBool(streamId, bitAND(dirtyMask, self.vehicleDirtyFlag) ~= 0) then
        end;
    end;
end;

function jd8530:mouseEvent(posX, posY, isDown, isUp, button)

end;

function jd8530:keyEvent(unicode, sym, modifier, isDown)
	
		
	   ---Help--
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;

	  --HandBrake---
	if isDown and sym == Input.KEY_y then
		self.handbrake = not self.handbrake; 
		if self.handbrake then
			playSample(self.handbrakeSoundId,1,1,0);
			brakeTorque = 600;
			self.motor.brakeForce = brakeTorque;
		end;
	end;
	
	
	
end;

function jd8530:update(dt)
	
    if self:getIsActive() then	
     	---Lampeggianti---
        for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;		
	end;
	
    if self.isEntered then
		if self.motor.minRpm < -2500 then
			self.motor.minRpm = -2500;
		elseif self.motor.minRpm > 100 then
			self.motor.minRpm = 100;
		end;
	end;
	
      
	-- Plafoniera ---
	if self.doorIObject == nil then
		for k,iObject in pairs(self.interactiveObjects) do
			if iObject.name == g_i18n:getText("leftDoor") then
				self.doorIObject = iObject;
			end;
		end;
	end;
	
		
	--HandBrake---
	if self.isEntered then

        
        if g_currentMission.allowSteerableMoving and not self.playMotorSound then
			
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0, true)
			end;
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0,true)
			end;
			
        if self.fuelFillLevel == 0 then
            acceleration = 0;
          end;
					
		end;
		
		if not self.handbrake then
		    brakeTorque = 20;
			self.motor.brakeForce = brakeTorque;
			setVisibility(self.handbrakelight, false);
		else
			if not Input.isKeyPressed(Input.KEY_s) then
				setVisibility(self.handbrakelight, true);
			end;
		end;		
		if Input.isKeyPressed(Input.KEY_s) then
			if not self.druckWarning then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -350;
					else
						self.druckLevel = self.druckLevel -250;
					end;
					self.braking = true;
				end;
				setVisibility(self.brakelight, true);
				if not self.brakePlaying then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			setVisibility(self.brakelight, false);
			self.braking = false;
			if not self.handbrake then
				brakeTorque = 20;
				self.motor.brakeForce = brakeTorque;
			end;
			if not self.brakereleasePlaying then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

		
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
	end;
	----Led Riserva-----
	if self.isEntered then
		if self.fuelFillLevel < 120 then
			self.riserva = self.riserva - dt;
			if self.riserva <= 120 then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.riserva = 30000;
			end;
			self.ledriservaActive = true;
		else
			self.riserva = 30000;
			self.ledriservaActive = false;
		end;
		setVisibility(self.ledriserva,self.ledriservaActive);
		self:updateFuelIndicators();
	end;
end;
function jd8530:updateTick(dt)

    if self:getIsActive() then	
					
			
		if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
			setVisibility(self.fuelIndicatorsGroup, true);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
			setVisibility(self.fuelIndicatorsGroup, false);
				
		end;
		 --Pedali--
		if self.camIndex == 1 then
			 if self.PedaleGas ~= nil then		
				local percent = (self.lastSpeed*self.speedDisplayScale*3600) / self.PedaleGas.maxSpeed;
				local minRot = self.PedaleGas.rotMin;
				local maxRot = self.PedaleGas.rotMax;
					
				local x = minRot[1] + (maxRot[1] - minRot[1]) * percent;
				local y = minRot[2] + (maxRot[2] - minRot[2]) * percent;
				local z = minRot[3] + (maxRot[3] - minRot[3]) * percent;
				setRotation(self.PedaleGas.node, x, y, z);
	        end;
		-- check Freno
			if self.PedaleFreno ~= nil then
				local x, y, z = getRotation(self.PedaleFreno.node);
				local rot = {x,y,z};
				local direction = -1;
				if self.invertedDrivingDirection then
				    direction = 1;
				else
				    direction = -1;
				end;
				local braking = math.abs(Utils.sign(self.lastAcceleration)+ (-self.movingDirection * direction)) == 2;
				local newRot = Utils.getMovedLimitedValues(rot, self.PedaleFreno.rotMax, self.PedaleFreno.rotMin, 3, self.PedaleFreno.rotTime, dt, braking);
				setRotation(self.PedaleFreno.node, unpack(newRot));
			end;
		end;
		
		if self.camIndex == 2 then
		
			if self.PedaleGas ~= nil then		
				local percent = (self.lastSpeed*self.speedDisplayScale*3600) / self.PedaleGas.maxSpeed;
				local minRot = self.PedaleGas.rotMin;
				local maxRot = self.PedaleGas.rotMax;
					
				local x = minRot[1] + (maxRot[1] - minRot[1]) * percent;
				local y = minRot[2] + (maxRot[2] - minRot[2]) * percent;
				local z = minRot[3] + (maxRot[3] - minRot[3]) * percent;
				setRotation(self.PedaleGas.node, x, y, z);
			end;
		end;
	
		
	end;
	
	-- Stop wipers in correct position
	if not self.finishWiperFront then
		if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
			setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.finishWiperFront = true;
		end;
	end;

	-- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperFrontOn then
		if not self.isWiperFrontActive then
			enableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.isWiperFrontActive = true;
		end;
		setRotation(self.wiperLever, 0, math.rad(-18), 0);
	else
		if self.isWiperFrontActive then
			self.isWiperFrontActive = false;
			self.finishWiperFront = false;
		end;
		setRotation(self.wiperLever, 0, 0, 0);
	end;
	
	-- switch
	
	if self.levaindicatori ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.levaindicatori, 0, math.rad(-20), math.rad(0));
			elseif self.B3.dirLeft[1].a then
				setRotation(self.levaindicatori, 0, math.rad(20), math.rad(0));
			else
				setRotation(self.levaindicatori, 0, 0, math.rad(0));
			end;
		else
			setRotation(self.levaindicatori, 0, 0, math.rad(0));
		end;
	end
            			
end;

function jd8530:updateFuelIndicators()
	local amountOfFuelPerIndicator = self.fuelCapacity/11;

	local timesToIterate = self.fuelFillLevel/amountOfFuelPerIndicator;

	timesToIterate = math.floor(timesToIterate);

	if self.oldTimesToIterate ~= timesToIterate then
		for i=1, self.numFuelIndicators do
			setVisibility(self.fuelIndicators[i].rotNode, false);
		end;

		for i=1, timesToIterate do
			setVisibility(self.fuelIndicators[i].rotNode, true);
	
		end;
	end;

	self.oldTimesToIterate = timesToIterate;
end;


function jd8530:draw()
   
	if self.isEntered then
		if not self.helpPanel then
			renderText(0.82, 0.21, 0.02, "Tryk KP 0: Info On");
		else
			renderText(0.82, 0.21, 0.02, "Tryk KP 0: Info Off");
		end;
		if self.helpPanel then
			renderText(0.02, 0.56, 0.023, "");
			renderText(0.02, 0.54, 0.021, "");
			renderText(0.02, 0.52, 0.021, "");
			renderText(0.02, 0.50, 0.021, "");
			renderText(0.02, 0.48, 0.021, "");
			renderText(0.02, 0.46, 0.021, "");
			renderText(0.02, 0.44, 0.021, "");
			renderText(0.02, 0.42, 0.021, "--INFO JD 8530--");
			renderText(0.02, 0.40, 0.021, "");
			renderText(0.02, 0.38, 0.021, "Tryk Space:IC Kontrol On/Off");
			renderText(0.02, 0.36, 0.021, "Tryk KP 5:Toparm in");
			renderText(0.02, 0.34, 0.021, "Tryk KP 4:Toparm out");
			renderText(0.02, 0.32, 0.021, "Tryk KP Enter:Start/Stop engine");
			renderText(0.02, 0.30, 0.021, "Tryk PageUp:ES limiter up");
			renderText(0.02, 0.28, 0.021, "Tryk PageDown:ES limiter down");
			renderText(0.02, 0.26, 0.021, "Tryk Delete:Twin back");
			renderText(0.02, 0.24, 0.021, "Tryk Insert:Twin front");
			renderText(0.02, 0.22, 0.021, "Tryk 8:4WD On/Off");
		end;
	end;
	if self.isEntered then
		if self.hudjohndeereOverlay ~= nil then
			self.hudjohndeereOverlay:render();
		end;
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(0.74, 0.26, 0.02, "Release handbeake");
			end;
			renderText(0.74, 0.22, 0.02, "(!) Handbreake aktiv (!)");	
		end;
		
		if self.druckWarning then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.74, 0.40, 0.02, "   Air preasure low.");
			renderText(0.74, 0.37, 0.02, "   Minimal breakeeffekt!");
		end;
	end;
	
	  if self.isMotorStarted then
	    --g_currentMission:addExtraPrintText(string.format(g_i18n:getText("GasLimiter_controls"), self.typeDesc) .. " " .. InputBinding.          getKeyNamesOfDigitalAction(InputBinding.mehrRPM) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.wenigerRPM));	
   end;
	
end;
function jd8530:attachImplement(implement)

end;
function jd8530:detachImplement(implementIndex)

end;
function jd8530:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function jd8530:onEnter()
        if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
		end
	if self.isWiperFrontActive then
		enableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	
end;

function jd8530:onLeave()
      self.motor.minRpm = 200;   
		 
	    if self.isMotorStarted then
			setVisibility(self.batteriaicona, false);
			setVisibility(self.olioicona, false);
		else			
			setVisibility(self.batteriaicona, true);
			setVisibility(self.olioicona, true);
	     end
		if self.isWiperFrontActive then
		disableAnimTrack(self.wiperFrontAnimCharSet, 0);
	    end;
	    
	
end;