--
-- Duels2
-- LS UK Modteam
--
-- author Henly20
-- date  20/11/2010
--

Duels2 = {};

function Duels2.prerequisitesPresent(specializations)
    return true;
end;

function Duels2:load(xmlFile)

	self.setDuelWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelWheelsVisibility");
	self.setDuelFWheelsVisibility = SpecializationUtil.callSpecializationsFunction("setDuelFWheelsVisibility");
	
      self.duelWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelWheels.duelWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelWheels, {node=node});
          end;
          i = i + 1;
      end;

      self.duelFWheels = {};
      local i = 0;
      while true do
          local key = string.format("vehicle.duelFWheels.duelFWheel(%d)", i);
          if not hasXMLProperty(xmlFile, key) then
              break;
          end;
          local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
          if node ~= nil then
              setVisibility(node, true);
              table.insert(self.duelFWheels, {node=node});
          end;
          i = i + 1;
      end;
end;

function Duels2:delete()

end;

function Duels2:readStream(streamId, connection)
	self.isLoading = true;
	local visibility = streamReadBool(streamId);
	self:setDuelWheelsVisibility(visibility, true);
	local visibilityfront = streamReadBool(streamId);
	self:setDuelFWheelsVisibility(visibilityfront, true);
	
end;

function Duels2:writeStream(streamId, connection)
	streamWriteBool(streamId, self.duelWheelsActive);
	streamWriteBool(streamId, self.duelFWheelsActive);
	
end;

function Duels2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Duels2:keyEvent(unicode, sym, modifier, isDown)
end;

function Duels2:update(dt)

      if self:getIsActiveForInput() and self.isClient then
          if InputBinding.hasEvent(InputBinding.TWINWHEELSBACK8530) then
              self:setDuelWheelsVisibility(not self.duelWheelsActive);
          end;
          if InputBinding.hasEvent(InputBinding.TWINWHEELSFRONT8530) then
              self:setDuelFWheelsVisibility(not self.duelFWheelsActive);
          end;
	end;
end;

function Duels2:updateTick(dt)



end;

function Duels2:onLeave()

end;

function Duels2:draw()

end;

function Duels2:setDuelWheelsVisibility(visibility, noEventSend)
      if visibility ~= self.duelWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetDuelRWheelsEvent:new(self, visibility), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetDuelRWheelsEvent:new(self, visibility));
              end;
          end;
  
          self.duelWheelsActive = visibility;
  
          for _, duelWheel in pairs(self.duelWheels) do
             setVisibility(duelWheel.node, visibility);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelWheelsVisibility ~= nil then
                 v.setDuelWheelsVisibility(self, visibility);
              end;
          end;
      end;
end;

function Duels2:setDuelFWheelsVisibility(visibilityfront, noEventSend)
      if visibilityfront ~= self.duelFWheelsActive then
  
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetDuelFWheelsEvent:new(self, visibilityfront), nil, nil, self);
              else
                  g_client:getServerConnection():sendEvent(SetDuelFWheelsEvent:new(self, visibilityfront));
              end;
          end;
  
          self.duelFWheelsActive = visibilityfront;
  
          for _, duelFWheel in pairs(self.duelFWheels) do
             setVisibility(duelFWheel.node, visibilityfront);
          end;
          for _,v in pairs(self.specializations) do
              if v.setDuelFWheelsVisibility ~= nil then
                 v.setDuelFWheelsVisibility(self, visibilityfront);
              end;
          end;
      end;
end;