--
-- JD7RSeriesFAN
-- Specialization FAN class for JD7RSeriesFAN
-- V1.0
-- @author  Ago-Systemtech
-- @date  26/06/2013
-- Copyright (C)Ago-Systemtech, All Rights Reserved.
--
--	for use this specialization on your mods...
-- 	@ Ago-Systemtech: https://www.facebook.com/ago.systemtech (Modhoster Team)
--	free for non commercial-usage! -------------

JD7RSeriesFAN = {};
JD7RSeriesFAN.modDir = g_currentModDirectory;

function JD7RSeriesFAN.prerequisitesPresent(specializations)

    return true;
end;
function JD7RSeriesFAN:load(xmlFile)

	local StartCofano = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Cofano#index"));
	if StartCofano ~= nil then
	    self.StartCofano = StartCofano;
	end;
	
	local StartLift = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.FrontLift#index" ));
	if StartLift ~= nil then
		self.StartLift = StartLift;
	end;
	------$$$$$$$$$$$---------
	self.playerCallbackDoor = SpecializationUtil.callSpecializationsFunction("playerCallbackDoor"); 
	
	self.doorO = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.Door#trigger")) );
	if trigger == nil then
		print("[Error::Door] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(xmlFile, string.format("vehicle.Door#icIndex", i));
	
	self.doorO.icIndex = icIndex;
	self.doorO.trigger = trigger;
	self.doorO.plIR = false;
		
	addTrigger( trigger, "playerCallbackDoor", self );		
	------$$$$$$$$$$$---------
	
	openHodSoundFile = Utils.getFilename("sound/closeHod.ogg", self.baseDirectory);
    self.openSoundId = createSample("hodsound");
    loadSample(self.openSoundId, openHodSoundFile, false);
    self.openhod = false;
	
	clouseHodSoundFile = Utils.getFilename("sound/openHod.ogg", self.baseDirectory);
    self.clouseSoundId = createSample("hodsound");
    loadSample(self.clouseSoundId, clouseHodSoundFile, false);
    self.closehod = false;

	-----------------SOUND VENTOLA------------------
	  local fanSound = getXMLString(xmlFile, "vehicle.fanSound#file");
		if fanSound ~= nil and fanSound ~= "" then
			fanSound = Utils.getFilename(fanSound, self.baseDirectory);
			self.fanSound = createSample("fanSound");
			loadSample(self.fanSound, fanSound, false);
			self.fanSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#pitchOffset"), 1);
			self.fanSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fanSound#volume"), 1);
			setSamplePitch(self.fanSound, self.fanSoundPitchOffset);
			self.fanSoundTime = 0;
			self.fanSoundEnabled = false;
      end;
	
	self.fanLed = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fanLed#index"));

end;
function JD7RSeriesFAN:delete()
		 
	 if self.fanSound ~= nil then
          delete(self.fanSound);
	end;
	if self.doorO.trigger ~= nil then
		removeTrigger(self.doorO.trigger);
	end;
   
end;
function JD7RSeriesFAN:readStream(streamId, connection)
		
end;
function JD7RSeriesFAN:writeStream(streamId, connection)
	
end;
function JD7RSeriesFAN:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
     return BaseMission.VEHICLE_LOAD_OK;
end;

function JD7RSeriesFAN:mouseEvent(posX, posY, isDown, isUp, button)
end;
function JD7RSeriesFAN:keyEvent(unicode, sym, modifier, isDown)
	
			
end;

function JD7RSeriesFAN:update(dt)
	 
	if self.isMotorStarted then
  
         if self:getIsActiveForSound() then
 
            if self.fanSound ~= nil and not self.fanSoundEnabled and self.fanSoundTime <= self.time then
                  playSample(self.fanSound, 1, self.fanSoundVolume, 0);
                  self.fanSoundTime = self.time + 240000;
                  self.fanSoundEnabled = true;
	
			end;
			if self.fanLed ~= nil then
				if self.fanSoundEnabled then
					setVisibility(self.fanLed, true);
				else
					setVisibility(self.fanLed, false);
				end;
			end
		end;
	end;
	
	if self.soundOpenhod then
       if not self.openhod then
            playSample(self.openSoundId, 1, 3, 3);
            self.openhod = true;
        end;
       
    else
        if self.openhod then
            stopSample(self.openSoundId);
            self.openhod = false;
        end;
         
    end;
	
	if self.soundClosehod then
       if not self.closehod then
            playSample(self.clouseSoundId, 1, 3, 3);
            self.closehod = true;
        end;
       
    else
        if self.closehod then
            stopSample(self.clouseSoundId);
            self.closehod = false;
        end;
         
    end;

		if g_currentMission.player ~= nil then
		------------cofano----------
	
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local rx, ry, rz = getWorldTranslation(self.StartCofano); 
		local distance = Utils.vector3Length(rx-vx, ry-vy, rz-vz);	
		if distance < nearestDistance then
			self.openCofano = true;
		else
			self.openCofano = false;
		end; 
		
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local sx, sy, sz = getWorldTranslation(self.StartLift); 
		local distance = Utils.vector3Length(sx-vx, sy-vy, sz-vz);	
		if distance < nearestDistance then
			self.openLift = true;
		else
			self.openLift = false;
		end; 
	
		end;

	
	-----------------
	if self.openCofano then
	if InputBinding.hasEvent(InputBinding.Cofano) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
				self.soundOpenhod = true;
				self.soundClosehod = false;
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
				self.soundOpenhod = false;
				self.soundClosehod = true;
			end;
		end;
	end;
	
		if self.openCofano then
		if self.animationParts[1].clipStartTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Aprire_Cofano"), self.typeDesc), InputBinding.Cofano);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Chiudere_Cofano"), self.typeDesc), InputBinding.Cofano);
			end;
		end
		
	if self.openLift then
		if InputBinding.hasEvent(InputBinding.FrontLift) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
				
			end;
		end;
	end; 

	if self.openLift then
	    if self.animationParts[3].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Lift_Open"), self.typeDesc), InputBinding.FrontLift);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Lift_Close"), self.typeDesc), InputBinding.FrontLift);
		end;
	end;
	------$$$$$$$$$$$---------
	if self.doorO.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_Door"), InputBinding.SET_Door );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		-- setTextAlignment(RenderText.ALIGN_LEFT); 				
		-- renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_Door") );
		if InputBinding.hasEvent(InputBinding.SET_Door)then
			local obj = self.interactiveObjects[self.doorO.icIndex];
			if obj ~= nil then
				--self.setDoor(not obj.isOpen);
				self:doActionOnObject(self.doorO.icIndex);
			end;
			
			--self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
		end
	end;
	------$$$$$$$$$$$---------
	
		if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
		end;
	    
	
	
end;

function JD7RSeriesFAN:updateTick(dt)
	

end;

function JD7RSeriesFAN:playerCallbackDoor(triggerId, otherId, onEnter, onLeave, onStay)
	
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = false;
	end;
	
end;

function JD7RSeriesFAN:draw()
 	
end;

function JD7RSeriesFAN:stopSounds()
	if self.isClient then
		 if self.fanSoundEnabled then
              stopSample(self.fanSound);
              self.fanSoundEnabled = false;
		 end;
	end;
	setVisibility(self.fanLed, false);
end;

function JD7RSeriesFAN:startMotor()
  -- if not self.isMotorStarted then
         -- self.isMotorStarted = true;
		self.fanSoundTime = self.time + 240000;
  -- end;
end;

function JD7RSeriesFAN:stopMotor()
  			
  JD7RSeriesFAN.stopSounds(self);
end;
function JD7RSeriesFAN:onEnter()
 
end;

function JD7RSeriesFAN:onLeave()
	 JD7RSeriesFAN.stopSounds(self);	
          
end;

