--
-- soundNew
-- Specialization for soundNew
--
-- @author Geri-G
-- @date  07/01/2011 v2.0.LS11
-- @web www.ls-modsource.com
--
-- Copyright (C) Geri-G, All Rights Reserved.

soundNew = {};

function soundNew.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function soundNew:load(xmlFile)

	--self.isSpeedLevelOff = false;
	--self.gurrentGear = 0;
	--self.gurrentDirGear = 1;
	--self.orgRPM = self.motor.maxRpm;
	--self.newRPM = {self.motor.maxRpm[3],self.motor.maxRpm[3],self.motor.maxRpm[3],self.motor.maxRpm[3]};
	--self.motor.maxRpm = self.newRPM;
	self.powerIn = {};
	self.powerIn.endTime = 0;
	self.powerIdle = {};
	self.powerOut = {};
	Utils.loadSample(xmlFile, self.powerIn, "vehicle.powerIn", "", self.baseDirectory);
	Utils.loadSample(xmlFile, self.powerIdle, "vehicle.powerIdle", "", self.baseDirectory);
	Utils.loadSample(xmlFile, self.powerOut, "vehicle.powerOut", "", self.baseDirectory);
	self.powerSound = false;
	self.soundTimer = 100;
	self.isOff = true;
	self.activeImplement = 0;
end;

function soundNew:updateTick(dt)	
	if self:getIsActiveForSound(false) then
		local active = 0;
		for k,v in pairs(self.attachedImplements) do
			if v.object.isTurnedOn then
				active = active+1;
			end;
		end;
		if self.motor.speedLevel >0 and self.motor.speedLevel <3 then
			--active = active+1;
		end;
		self.soundTimer = self.soundTimer-dt
		self.activeImplement = active;
		if active >0 and not self.powerSound then
			stopSample(self.powerOut.sample);
			self.powerOut.isPlaying = false;
			self.powerSound = true;
            if self.powerIn ~= nil and not self.powerIn.isPlaying then
                playSample(self.powerIn.sample, 1, self.powerIn.volume, 0);
                setSamplePitch(self.powerIn.sample,self.powerIn.pitchOffset);
                self.powerIn.isPlaying = true;
				self.powerIn.endTime = self.time + getSampleDuration(self.powerIn.sample);
            end;
			self.isOff = false;

		elseif active >0 and self.powerSound and self.powerIn.endTime <=self.time and not self.powerIdle.isPlaying and not self.powerOut.isPlaying then
            stopSample(self.powerIn.sample);
			self.powerIn.isPlaying = false;
			if self.powerIdle ~= nil and not self.powerIdle.isPlaying then
                playSample(self.powerIdle.sample, 0, self.powerIdle.volume, 0);
                setSamplePitch(self.powerIdle.sample,self.powerIdle.pitchOffset);
                self.powerIdle.isPlaying = true;
            end;
			self.isOff = false;
		elseif active == 0 and self.powerSound and not self.powerOut.isPlaying then
            stopSample(self.powerIn.sample);
            stopSample(self.powerIdle.sample);
			self.powerIn.isPlaying = false;
			self.powerIdle.isPlaying = false;
			self.powerSound = false;
			if self.powerOut ~= nil and not self.powerOut.isPlaying then
                playSample(self.powerOut.sample,1, self.powerOut.volume, 0);
                setSamplePitch(self.powerOut.sample,self.powerOut.pitchOffset);
                self.powerOut.isPlaying = true;
            end;
			self.isOff = false;
			self.soundTimer = 1000;
		elseif active == 0 and self.isOff == false and self.soundTimer <= 0 then
			setSampleVolume(self.motorSound, self.motorSoundVolume)
			--setSampleVolume(self.motorSoundRun, self.motorSoundRunVolume)
			self.isOff = true;
		end;
	end;
end;
function soundNew:update(dt)
	if self:getIsActiveForSound(false) then
		if self.activeImplement >0 and self.powerSound then
			setSampleVolume(self.motorSound, 0);
			--setSampleVolume(self.motorSoundRun, 0);
		end;
	end;
end;

function soundNew:draw()

end;
function soundNew:onLeave()
	stopSample(self.powerIn.sample);
	stopSample(self.powerIdle.sample);
	stopSample(self.powerOut.sample);
	self.powerIn.isPlaying = false;
	self.powerIdle.isPlaying = false;
	self.powerOut.isPlaying = false;
	self.isOff = true;
	self.powerSound = false;
end;

function soundNew:onEnter()

end;

function soundNew:delete()
	delete(self.powerIn.sample);
	delete(self.powerIdle.sample);
	delete(self.powerOut.sample);
end;

function soundNew:mouseEvent(posX, posY, isDown, isUp, button)
end;

function soundNew:keyEvent(unicode, sym, modifier, isDown)
end;


--[[
function soundNew:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local i = 0;
		while true do	
			local base=key..string.format(".anim(%d)",i);
			local animName= getXMLString(xmlFile,base.."#name");
			if animName=="" or animName==nil then
				break;
			end;
			local AnimationTime= getXMLFloat(xmlFile,base.."#AnimationTime");
			if animName=="trsp" and AnimationTime >0 then
				self:invertSteering(AnimationTime >0 ,true);
			end;
			local isBlocked= getXMLBool(xmlFile,base.."#isBlocked");
			if self.animations[animName] ~= nil then
				if isBlocked then
					self.animations[animName].currentTime = AnimationTime*self.animations[animName].duration;
				else
					self:playAnimation(animName, -1, math.max(AnimationTime+0.1,0));
					self:setAnimationStopTime(animName, AnimationTime);
				end;	
			end;	
			i=i+1;
		end;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function soundNew:getSaveAttributesAndNodes(nodeIdent)
	--local attributes = 'trsp="'..tostring(self.trsp)..'" steer="'..tonumber(self.changeWheel)..'"';
	local nodes="";
	local nodes2="";
	for k,v in pairs(self.animations) do
		local currentAnimTime = self:getAnimationTime(k);
		if k=="trsp" then		
			nodes2 = '\n'..nodeIdent..'<anim name="'..k..'" AnimationTime="'..tostring(currentAnimTime)..'" isBlocked="'..tostring(self:getIsAnimBlocked(v,k))..'"/>'
		else	
			nodes = nodes..'\n'..nodeIdent..'<anim name="'..k..'" AnimationTime="'..tostring(currentAnimTime)..'" isBlocked="'..tostring(self:getIsAnimBlocked(v,k))..'"/>';
		end;
	end;
	nodes =nodes2..nodes;
	nodes = string.sub(nodes,2);
	return attributes, nodes;
end;
function soundNew:readStream(streamId, connection)
    local invertedDrivingDirection = streamReadInt8(streamId);
    self:invertSteering(invertedDrivingDirection,true);
end;

function soundNew:writeStream(streamId, connection)
    streamWriteBool(streamId, self.invertedDrivingDirection);
end;

]]

