--
-- Specialisation for John Deere 6930 Premium
-- Date: 23.11.12
-- Version 1
-- Author: Timber131
-- temp:function JohnDeere_6930P.prerequisitesPresent(specializations)
-- return SpecializationUtil.hasSpecialization(Motorized, specializations);
-- end;

JohnDeere_6930P = {};

function JohnDeere_6930P.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JohnDeere_6930P:load(xmlFile)
	self.tankicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankicon#index"));
	self.batterieicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batterieicon#index"));
end;

function JohnDeere_6930P:delete()
end;

function JohnDeere_6930P:readStream(streamId, connection)
end;

function JohnDeere_6930P:writeStream(streamId, connection)
end;

function JohnDeere_6930P:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere_6930P:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeere_6930P:update(dt)
end;

function JohnDeere_6930P:updateTick(dt)

    if self:getIsActive(false) then	
		-- check if currentcam is indoorcam
		if self.camIndex == 2 then
		end;
		if self.isMotorStarted then
			local currentFuelPercentage = 0;
			local fuelWarnPercentage = 20;
			if self.fuelCapacity > 0 then
				currentFuelPercentage = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			if currentFuelPercentage < fuelWarnPercentage then
				setVisibility(self.tankicon, true);
			else
				setVisibility(self.tankicon, false);
			end;
			setVisibility(self.batterieicon, false);
			end;
		else
			setVisibility(self.batterieicon, true);
			setVisibility(self.tankicon, false);
		end;
	end;
end;

function JohnDeere_6930P:draw()
end;

function JohnDeere_6930P:attachImplement(implement)
end;

function JohnDeere_6930P:detachImplement(implementIndex)
end;

function JohnDeere_6930P:validateAttacherJoint(implement, jointDesc, dt)
end;

function JohnDeere_6930P:onLeave()
	if self.isMotorStarted then
	   setVisibility(self.batterieicon, false);
	else
	   setVisibility(self.batterieicon, true);
	end;
end;

function JohnDeere_6930P:onEnter()
	if self.isMotorStarted then
	   setVisibility(self.batterieicon, false);
	else
	   setVisibility(self.batterieicon, true);
	end;
end;

