--
-- Hydraulik
--
-- @author Geri-G
-- @date  12/07/2011 v1.0 LS11
-- @web www.geri-g.de
--
-- Copyright (C) Geri-G, All Rights Reserved.

Hydraulik = {};

function Hydraulik.prerequisitesPresent(specializations)
	print("specialization Hydraulik v1 by Geri-G");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Hydraulik:load(xmlFile)
	self.oldGetAttachedIndexFromJointDescIndex = self.getAttachedIndexFromJointDescIndex;
	self.getAttachedIndexFromJointDescIndex = Hydraulik.getAttachedIndexFromJointDescIndex;

	self.blockedJointsBack = {};


	local blockedJointsBack = {Utils.getVectorFromString(getXMLString(xmlFile,"vehicle.AKBack#blockedIndexes"))};
	for k,v in pairs(blockedJointsBack) do
		if self.attacherJoints[tonumber(v)] ~=nil then
			self.blockedJointsBack[tonumber(v)] = true;
		end;	
	end;	
	self.blockedJointsFront = {};
	local blockedJointsFront = {Utils.getVectorFromString(getXMLString(xmlFile,"vehicle.AKFront#blockedIndexes"))};
	for k,v in pairs(blockedJointsFront) do
		if self.attacherJoints[tonumber(v)] ~=nil then
			self.blockedJointsFront[tonumber(v)] = true;
		end;	
	end;	


	self.currentBackIndex = nil;
	self.currentFrontIndex = nil;
	
	self.backHydro = {};
	local base = "vehicle.backHydro";
	self.backHydro.attachJoint = getXMLInt(xmlFile,base.."#attacherIndices");	
	self.frontHydro = {};
	local base = "vehicle.frontHydro";
	self.frontHydro.attachJoint = getXMLInt(xmlFile,base.."#attacherIndices");
	self.frontHydro.foldOutAnim = getXMLString(xmlFile,base.."#FoldOutAnim");

	local i=0;
	while true do
		local base = string.format("vehicle.attacherJoints.attacherJoint(%d)",i);
		local joint = self.attacherJoints[i+1];
		if joint == nil then 
			break;
		end;
		local node = Utils.indexToObject(self.components,getXMLString(xmlFile,base.."#index"));
		if node ~= joint.jointTransform or node== nil then
			break;
		end;
		joint.referenceNode = Utils.indexToObject(self.components,getXMLString(xmlFile,base..".bottomArm#referenceNode"));
		joint.powerShaftAttacher = Utils.indexToObject(self.components,getXMLString(xmlFile,base.."#shaft"));
		i=i+1;

	end;	

	local i2=0;
	while true do
		local base = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)",i2);
		local joint = self.attacherJoints[i+1];
		if joint == nil then 
			break;
		end;
		local node = Utils.indexToObject(self.components,getXMLString(xmlFile,base.."#index"));
		if node ~= joint.jointTransform or node== nil then
			break;
		end;
		joint.powerShaftAttacher = Utils.indexToObject(self.components,getXMLString(xmlFile,base.."#shaft"));
		i2=i2+1;
		i=i+1;
	end;
	
	self.toolsToCheck = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.movingTools.movingTool(%d)", i);
		local index = getXMLString(xmlFile,baseName.."#index");
		if index ~= nil then
			if getXMLBool(xmlFile,baseName.."#verify") == true then
				local entry = {};
				entry.node = Utils.indexToObject(self.components,index);
				entry.lastRot = {getRotation(entry.node)};
				entry.lastTrans = {getTranslation(entry.node)};
				table.insert(self.toolsToCheck, entry);
			end;
			i=i+1;
		else
			break;
		end;
	end;
	self.firstRun = true;
	
end;
function Hydraulik:updateTick(dt)
	if self:getIsActive(false) then	
		local jointDesc = self.attacherJoints[self.backHydro.attachJoint+1];

		local x,y,z = getWorldTranslation(jointDesc.referenceNode);
		x,y,z =worldToLocal(getParent(jointDesc.jointTransform),x,y,z);
		local x1,y1,z1 = getTranslation(jointDesc.jointTransform);
		if z ~= z1 then
			setTranslation(jointDesc.jointTransform,x1,y1,z);
			setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
		end;		
		local jointDesc = self.attacherJoints[self.frontHydro.attachJoint+1];
		local x,y,z = getWorldTranslation(jointDesc.referenceNode);
		x,y,z =worldToLocal(getParent(jointDesc.jointTransform),x,y,z);
		local x1,y1,z1 = getTranslation(jointDesc.jointTransform);
		if z ~= z1 then
			setTranslation(jointDesc.jointTransform,x1,y1,z);
			setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
		end;
		for k,tool in ipairs(self.toolsToCheck) do
			local curRot = {getRotation(tool.node)};
			local curTrans = {getTranslation(tool.node)};
			local hasChanged = false;
			if not Utils.areListsEqual(tool.lastRot,curRot) then
				tool.lastRot = curRot;
				hasChanged = true;
			end;
			if not Utils.areListsEqual(tool.lastTrans,curTrans) then
				tool.lastTrans = curTrans;
				hasChanged = true;
			end;
			if hasChanged then
				self:setMovingToolDirty(tool.node);
				self.firstRun = false;
			end;
			if self.firstRun then
				for i, part in ipairs(self.movingParts) do
					Cylindered.updateMovingPart(self, part);
				end;
				self.firstRun = false;
			end;
		end;
	end;
	
end;
function Hydraulik:update(dt)

end;

function Hydraulik:draw()
	--g_currentMission:addHelpButtonText("Xml nachladen", InputBinding.Key1_DeaktivateAttacher);
end;
function Hydraulik:onLeave()

end;

function Hydraulik:onEnter()

end;

function Hydraulik:delete()

end;

function Hydraulik:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Hydraulik:keyEvent(unicode, sym, modifier, isDown)
end;

function Hydraulik:attachImplement(implement)
	if self.blockedJointsBack[implement.jointDescIndex]~= nil then
		for k,v in pairs(self.blockedJointsBack) do
			if k ~=implement.jointDescIndex then
				self.attacherJoints[k].jointIndex = -1;
			else
				self.currentBackIndex = k;
			end;
		end;
	end;	
	if self.blockedJointsFront[implement.jointDescIndex]~= nil then
		for k,v in pairs(self.blockedJointsFront) do
			if k ~=implement.jointDescIndex then
				self.attacherJoints[k].jointIndex = -1;
			else
				self.currentFrontIndex = k;
			end;
		end;
	end;	
	if implement.jointDescIndex == self.frontHydro.attachJoint+1 then
		self:playAnimation(self.frontHydro.foldOutAnim, 1);			
	end;
end;
function Hydraulik:detachImplement(implementIndex)
    local implement = self.attachedImplements[implementIndex];
	if self.blockedJointsBack[implement.jointDescIndex]~= nil then
		for k,v in pairs(self.blockedJointsBack) do
			if k ~=implement.jointDescIndex then
				self.attacherJoints[k].jointIndex = 0;
			end;
		end;
	end;	
	if self.blockedJointsFront[implement.jointDescIndex]~= nil then
		for k,v in pairs(self.blockedJointsFront) do
			if k ~=implement.jointDescIndex then
				self.attacherJoints[k].jointIndex = 0;
			end;
		end;
	end;
	self.currentFrontIndex = nil;
	self.currentBackIndex = nil;
	if implement.jointDescIndex == self.frontHydro.attachJoint+1 then
		self:playAnimation(self.frontHydro.foldOutAnim, -1);			
	end;
	
end;
function Hydraulik:getAttachedIndexFromJointDescIndex(jointDescIndex)
    local ret = self:oldGetAttachedIndexFromJointDescIndex(jointDescIndex);
	
	if self.attacherJoints[jointDescIndex].jointIndex == -1 and ret == nil then
		if self.currentBackIndex ~= nil and self.blockedJointsBack[jointDescIndex]~=nil then
			return self:getAttachedIndexFromJointDescIndex(self.currentBackIndex);
		elseif self.currentFrontIndex ~= nil  and self.blockedJointsFront[jointDescIndex]~=nil then
			return self:getAttachedIndexFromJointDescIndex(self.currentFrontIndex);
		end;
	else
		return ret;
	end;
end;

