
CutterExtra = {};

function CutterExtra.prerequisitesPresent(specializations)
    return true;
end;

function CutterExtra:load(xmlFile)
    self.rolNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index1"));
    self.rolNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index2"));
	
	self.ExcavatorsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Excavators#count"), 0);	
	self.Excavators = {};	
	for i=1, self.ExcavatorsCount do
		local ExcavatorName = string.format("vehicle.Excavators.Excavator%d", i);		
		self.Excavators[i] = {};		
		self.Excavators[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, ExcavatorName .. "#index"));
		self.Excavators[i].speed = getXMLInt(xmlFile, ExcavatorName .. "#speed");
	end;
end;

function CutterExtra:delete()
end;

function CutterExtra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CutterExtra:keyEvent(unicode, sym, modifier, isDown)
end;

function CutterExtra:update(dt)
    self.reelSpeed = 0.0035;
	if self.reelStarted then
        if self.rolNode2 ~= nil then
            rotate(self.rolNode2, -dt*self.reelSpeed*4, 0, 0);
        end;         
		if self.rolNode1 ~= nil then
            rotate(self.rolNode1, dt*self.reelSpeed*3, 0, 0);
        end;    
		for i=1, table.getn(self.Excavators) do
			setShaderParameter(self.Excavators[i].node, "partScale",self.Excavators[i].speed,1,0, 0, false);
		end;
	else
		for i=1, table.getn(self.Excavators) do
			setShaderParameter(self.Excavators[i].node, "partScale",90000000000,1,0, 0, false);
		end;
	end;
end;

function CutterExtra:draw()
end;

function CutterExtra:onDetach()
end;

function CutterExtra:onLeave()
end;

function CutterExtra:onDeactivate()
end;


