-- Collisions
-- Specialization based on Gebistorf. Thanks to Tobias F. (John Deere 6930, 1. LS-Modschmiede)


Collisions = {};

function Collisions.prerequisitesPresent(specializations)
    return true;
end;

function Collisions:load(xmlFile)

	local Collision1 = {};
	Collision1.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#collision"));
	Collision1.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#collsionAttacher"));
	Collision1.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#armAttacher"));
	Collision1.index = 0;
	self.Collision1Base = Collision1;	

	local rotationNodeSupport = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationSupport#index"));
    if rotationNodeSupport ~= nil then
        self.rotationSupport = {};
        self.rotationSupport.node = rotationNodeSupport;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSupport#minRot"));
        self.rotationSupport.minRot = {};
        self.rotationSupport.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSupport.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSupport.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationSupport#maxRot"));
        self.rotationSupport.maxRot = {};
        self.rotationSupport.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationSupport.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationSupport.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationSupport.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSupport#rotTime"), 2)*1000;
        self.rotationSupport.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationSupport#touchRotLimit"), 10));
    end; 	
	

	self.collisions = true;
		
end;

function Collisions:delete()
end;

function Collisions:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Collisions:keyEvent(unicode, sym, modifier, isDown)
end;

function Collisions:update(dt)


	local doRotate = self.rotationSupportMax or self.rotationSupportMin 
	if self.rotationSupport ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSupport.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSupport.maxRot, self.rotationSupport.minRot, 3, self.rotationSupport.rotTime, dt, not self.rotationSupportMax);
        setRotation(self.rotationSupport.node, unpack(newRot));
    end;	
	
	
		local CollisionBase1 = self.Collision1Base;
		setJointFrame(CollisionBase1.index, 0, CollisionBase1.armAttacher);
	    if self.collisions then
			self.collisions = false;
			local constr = JointConstructor:new();
			constr:setActors(self.rootNode, self.Collision1Base.collision);
			constr:setJointTransforms(self.Collision1Base.armAttacher, self.Collision1Base.collisionAttacher);
			for i=1, 3 do
				constr:setRotationLimit(i-1, 0, 0, 0);
				constr:setTranslationLimit(i-1, true, 0, 0);
			end;
			self.Collision1Base.index = constr:finalize();
		end;


end;

function Collisions:draw()
end;

function Collisions:onDetach()
		self.rotationSupportMin = true;
		self.rotationSupportMax = false;
end;

function Collisions:onAttach()
		self.rotationSupportMin = false;
		self.rotationSupportMax = true;
end;