--
-- Name: Inversore Control
-- Description: Inversore implementation for steerables
-- Version: 2.0
-- Author: Templaer
-- Date: 10/04/2011
-- @DATE  	14/06/13 ADD FIX FOR USE JD 7R SERIES and use on mod, Ago-Systemtech: https://www.facebook.com/ago.systemtech (Modhoster Team)
-- free for non commercial-usage--------

InversoreControl = {}
function InversoreControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;
-- Extended original functions --
function InversoreControl:load(xmlFile) 
	self.setInversoreDirection = InversoreControl.setInversoreDirection;
	self.setInversoreEnabled = InversoreControl.setInversoreEnabled;
	self.InversoreOverride = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.InversoreControl#override"), false);
	self.InversoreEnabled = true;
	self.InversoreDirection = 1;
	
	
	self.frontled = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontled#index"));
	self.reverseled = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reverseled#index"));
	
end;

function InversoreControl:readStream(streamId, connection)
	local InversoreDirection = streamReadInt32(streamId);
	self:setInversoreDirection(InversoreDirection, true);	
	
	local InversoreEnabled = streamReadBool(streamId);
	self:setInversoreEnabled(InversoreEnabled, true);
end;

function InversoreControl:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.InversoreDirection);	
	streamWriteBool(streamId, self.InversoreEnabled);	
end;

function InversoreControl:update(dt) 
	 if not self.InversoreOverride then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.AVVIA_INVERSORE) then
				self:setInversoreEnabled(not self.InversoreEnabled);
			end;
		end;
		
		if self.InversoreEnabled then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.CAMBIA_DIREZIONE) then
					self:setInversoreDirection(-self.InversoreDirection);
					if self.setInversoreDirection and self:getIsActiveForSound() then
					playSample(self.InversoreDirectionSoundId,1,1,1);
					end;
				end;
			end;
		end;
 end;

end;


function InversoreControl:mouseEvent(posX, posY, isDown, isUp, button)
end;
function InversoreControl:keyEvent(unicode, sym, modifier, isDown)
end;
function InversoreControl:draw() 
	 
	 if not self.InversoreOverride then
		
		g_currentMission:addHelpButtonText(g_i18n:getText("AVVIA_INVERSORE"), InputBinding.AVVIA_INVERSORE);
		
		if self.InversoreEnabled then
			if self.InversoreDirection == 1 then
				g_currentMission:addHelpButtonText(g_i18n:getText("Inversore_control_forwards"), InputBinding.CAMBIA_DIREZIONE);
				 setVisibility(self.frontled, true);
				  setVisibility(self.reverseled, false);
			else
				g_currentMission:addHelpButtonText(g_i18n:getText("Inversore_control_backwards"), InputBinding.CAMBIA_DIREZIONE);
				  setVisibility(self.reverseled, true);
				  setVisibility(self.frontled, false);
			end;
		end;
	end;
end;

function InversoreControl:delete()
 
end
-- New functions --
function InversoreControl:setInversoreDirection(InversoreDirection, noEventSend) 
	SetInversoreDirectionEvent.sendEvent(self, InversoreDirection, noEventSend);
	self.InversoreDirection = InversoreDirection;
end;

function InversoreControl:setInversoreEnabled(InversoreEnabled, noEventSend)
	SetInversoreEnabledEvent.sendEvent(self, InversoreEnabled, noEventSend);
	self.InversoreEnabled = InversoreEnabled;
end;


-- Name: SetInversoreDirectionEvent
-- Description: Set Inversore direction event for the Steerable specialization
-- Version: 2.0
-- Author: Templaer
-- Date: 10/04/2011
--

SetInversoreDirectionEvent = {};
SetInversoreDirectionEvent_mt = Class(SetInversoreDirectionEvent, Event);

InitEventClass(SetInversoreDirectionEvent, "SetInversoreDirectionEvent");

function SetInversoreDirectionEvent:emptyNew()
	local self = Event:new(SetInversoreDirectionEvent_mt);
	self.className="SetInversoreDirectionEvent";
	return self;
end;

function SetInversoreDirectionEvent:new(object, InversoreDirection)
	local self = SetInversoreDirectionEvent:emptyNew()
	self.object = object;
	self.InversoreDirection = InversoreDirection;
	return self;
end;

function SetInversoreDirectionEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.InversoreDirection = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetInversoreDirectionEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.InversoreDirection);
end;

function SetInversoreDirectionEvent:run(connection)
	self.object:setInversoreDirection(self.InversoreDirection, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetInversoreDirectionEvent:new(self.object, self.InversoreDirection), nil, connection, self.object);
	end;
end;

function SetInversoreDirectionEvent.sendEvent(vehicle, InversoreDirection, noEventSend)
	if InversoreDirection ~= vehicle.InversoreDirection then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetInversoreDirectionEvent:new(vehicle, InversoreDirection), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetInversoreDirectionEvent:new(vehicle, InversoreDirection));
			end;
		end;
	end;
end;

-- Name: SetInversoreEnabledEvent
-- Description: Set Inversore enabled event for the Steerable specialization
-- Version: 2.0
-- Author: Templaer
-- Date: 10/04/2011
--

SetInversoreEnabledEvent = {};
SetInversoreEnabledEvent_mt = Class(SetInversoreEnabledEvent, Event);

InitEventClass(SetInversoreEnabledEvent, "SetInversoreEnabledEvent");

function SetInversoreEnabledEvent:emptyNew()
	local self = Event:new(SetInversoreEnabledEvent_mt);
	self.className="SetInversoreEnabledEvent";
	return self;
end;

function SetInversoreEnabledEvent:new(object, InversoreEnabled)
	local self = SetInversoreEnabledEvent:emptyNew()
	self.object = object;
	self.InversoreEnabled = InversoreEnabled;
	return self;
end;

function SetInversoreEnabledEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.InversoreEnabled = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SetInversoreEnabledEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.InversoreEnabled);
end;

function SetInversoreEnabledEvent:run(connection)
	self.object:setInversoreEnabled(self.InversoreEnabled, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetInversoreEnabledEvent:new(self.object, self.InversoreEnabled), nil, connection, self.object);
	end;
end;

function SetInversoreEnabledEvent.sendEvent(vehicle, InversoreEnabled, noEventSend)
	if InversoreEnabled ~= vehicle.InversoreEnabled then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetInversoreEnabledEvent:new(vehicle, InversoreEnabled), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetInversoreEnabledEvent:new(vehicle, InversoreEnabled));
			end;
		end;
	end;
end;