--
-- Specialisation for John Deere 7530 Premium
-- Date: 14.5.12
-- Version 1
-- Author: Sicka
-- temp:function JohnDeere7530Premium.prerequisitesPresent(specializations)
--    return SpecializationUtil.hasSpecialization(Motorized, specializations);
-- end;

JohnDeere7530Premium = {};

function JohnDeere7530Premium.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function JohnDeere7530Premium:load(xmlFile)
	self.tankicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankicon#index"));
	self.batterieicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.batterieicon#index"));
end;

function JohnDeere7530Premium:delete()
end;

function JohnDeere7530Premium:readStream(streamId, connection)
end;

function JohnDeere7530Premium:writeStream(streamId, connection)
end;

function JohnDeere7530Premium:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JohnDeere7530Premium:keyEvent(unicode, sym, modifier, isDown)
end;

function JohnDeere7530Premium:update(dt)
end;

function JohnDeere7530Premium:updateTick(dt)

    if self:getIsActive() then	
		-- check if currentcam is indoorcam
		if self.camIndex == 2 then
		end;
		if self.isMotorStarted then
			local currentFuelPercentage = 0;
			local fuelWarnPercentage = 20;
			if self.fuelCapacity > 0 then
				currentFuelPercentage = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			if currentFuelPercentage < fuelWarnPercentage then
				setVisibility(self.tankicon, true);
			else
				setVisibility(self.tankicon, false);
			end;
			setVisibility(self.batterieicon, false);
			end;
		else
			setVisibility(self.batterieicon, true);
			setVisibility(self.tankicon, false);
		end;
	end;
end;

function JohnDeere7530Premium:draw()
end;

function JohnDeere7530Premium:attachImplement(implement)
end;

function JohnDeere7530Premium:detachImplement(implementIndex)
end;

function JohnDeere7530Premium:validateAttacherJoint(implement, jointDesc, dt)
end;

function JohnDeere7530Premium:onLeave()
	if self.isMotorStarted then
	   setVisibility(self.batterieicon, false);
	else
	   setVisibility(self.batterieicon, true);
	end;
end;

function JohnDeere7530Premium:onEnter()
	if self.isMotorStarted then
	   setVisibility(self.batterieicon, false);
	else
	   setVisibility(self.batterieicon, true);
	end;
end;

