--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight;
		local xRot = getXMLFloat(xmlFile, buttonName .. "#xRot");
		local yRot = getXMLFloat(xmlFile, buttonName .. "#yRot");
		local zRot = getXMLFloat(xmlFile, buttonName .. "#zRot");
		if xRot == nil and yRot == nil and zRot == nil then
			highlight = getChildAt(mark, 0);
		end;		
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, xRot, yRot, zRot, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(xmlFile, buttonName .. "#synch"), false);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, xRot, yRot, zRot, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, xRot, yRot, zRot, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	instance.lastdt = 100;
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	self.lastdt = dt;
	if self.vehicle ~= nil then
		if self.event == "toggleFrontWorklights" then
			if self.vehicle.B3.work[1].a ~= self.isOpen then
			 self.isOpen = self.vehicle.B3.work[1].a;
			 end;
		elseif self.event == "toggleBackWorklights" then
			if self.vehicle.B3.work[3].a ~= self.isOpen then
			 self.isOpen = self.vehicle.B3.work[3].a;
			 end;
		elseif self.event == "toggleFrontlights" then
			if self.vehicle.realLightsActive ~= self.isOpen then
			self.isOpen = self.vehicle.realLightsActive;
			end
		elseif self.event == "toggleWarningLights" then	
			if self.vehicle.B3.wl ~= self.isOpen then		
			self.isOpen = self.vehicle.B3.wl;
			end;
		elseif self.event == "toggleRightIndicator" then
			if self.vehicle.B3.dirRight[1].a ~= self.isOpen then
			self.isOpen = self.vehicle.B3.dirRight[1].a ;
			end;
		elseif self.event == "toggleLeftIndicator" then	
			if self.vehicle.B3.dirRight[1].a ~= self.isOpen then
			self.isOpen = self.vehicle.B3.dirRight[1].a ;
			end;
		elseif self.event == "toggleallrad" then
			if self.vehicle.AllradV41Active ~= self.isOpen then		
			self.isOpen = self.vehicle.AllradV41Active ;
			end;
		end;
	end;
	
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	if self.vehicle ~= nil then
		if self.event == "toggleFrontWorklights" then	
             if self.frontworkActive then
                self.isOpen = false;
                self.vehicle:setState("work:1", false);
				self.vehicle:setState("work:2", false);
                self.frontworkActive = false;
            else
                self.isOpen = true;
                self.vehicle:setState("work:1", true);
				self.vehicle:setState("work:2", true);
                self.frontworkActive = true;
            end;
		elseif self.event == "toggleBackWorklights" then	
             if self.backworkActive then
                self.isOpen = false;
                self.vehicle:setState("work:3", false);
                self.backworkActive = false;
            else
                self.isOpen = true;
                self.vehicle:setState("work:3", true);
                self.backworkActive = true;
            end;
		elseif self.event == "toggleFrontlights" then
			if self.vehicle.realLightsActive then
				self.vehicle:setLightsVisibility(false, noEventSend);
			else
				self.vehicle:setLightsVisibility(true, noEventSend);
			end;
		elseif self.event == "toggleWarningLights" then
			if self.vehicle.B3.wl then
				self.vehicle:setState("warnlights", false, noEventSend);
				self.vehicle:setState("dirLeft", false, noEventSend);
				self.vehicle:setState("dirRight", false, noEventSend);
			else
				self.vehicle:setState("warnlights", true, noEventSend);
				self.vehicle:setState("dirLeft", true, noEventSend);
				self.vehicle:setState("dirRight", true, noEventSend);
			end;
		elseif self.event == "toggleRightIndicator" then
			if self.vehicle.B3.dirRight[1].a then
				self.vehicle:setState("warnlights", false, noEventSend);
				self.vehicle:setState("dirLeft", false, noEventSend);
				self.vehicle:setState("dirRight", false, noEventSend);
			else
				self.vehicle:setState("warnlights", false, noEventSend);
				self.vehicle:setState("dirLeft", false, noEventSend);
				self.vehicle:setState("dirRight", true, noEventSend);
			end;
		elseif self.event == "toggleLeftIndicator" then
			if self.vehicle.B3.dirLeft[1].a then
				self.vehicle:setState("warnlights", false, noEventSend);
				self.vehicle:setState("dirLeft", false, noEventSend);
				self.vehicle:setState("dirRight", false, noEventSend);
			else
				self.vehicle:setState("warnlights", false, noEventSend);
				self.vehicle:setState("dirLeft", true, noEventSend);
				self.vehicle:setState("dirRight", false, noEventSend);
			end;
		elseif self.event == "lowerBack" then
			if self.vehicle.lowerBack then
				self.vehicle:setJointMoveDown(1, false);
				self.vehicle.lowerBack = false;
			else
				self.vehicle:setJointMoveDown(1, true);
				self.vehicle.lowerBack = true
			end;
		elseif self.event == "lowerBack2" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
		elseif self.event == "lowerFront" then
		if self.vehicle.lowerFront then
			self.vehicle:setJointMoveDown(2, false);
			self.vehicle.lowerFront = false;
		else
			self.vehicle:setJointMoveDown(2, true);
			self.vehicle.lowerFront = true;
		end;
	
		elseif self.event == "ptoToggle" then
		for k, implement in pairs(self.vehicle.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn ~= nil then
						if implement.object.isTurnedOn then
							implement.object.isTurnedOn = false;
						else
							implement.object.isTurnedOn = true;
						end;
					end;
				end;
		end;
		elseif self.event == "toggleallrad" then
		self.vehicle:allradState(not self.vehicle.AllradV41Active);
			
		elseif self.event == "toggleBeaconLights" then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;
end;
	

end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;