--
-- Copyright ? 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_PivotingAxle
-- Specialization for pivoting axle mod
--
-- @author  	JoXXer
-- @date  		01/08/13
--
-- @history		v1.0 - Initial implementation
--				v1.0.2 - 30/09/13 - Camber adjustments as suggested by dural
--

Assale = {}

function Assale.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Assale:load(xmlFile)
		----- Front axle animation -----
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));
		-------------PARAFANGHI - ANIMAZIONI RUOTE --------------
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.wheelCamberAngle = (Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedWheels#camberAngle"), 0))/100;
	self.fenderAngle = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#fenderAngle"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;
end;
      
function Assale:delete()
end;

function Assale:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function Assale:keyEvent(unicode, sym, modifier, isDown)
end;

function Assale:update(dt)
    if self:getIsActive() then
		
		------------ Front axle animation --------------
					
	  if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[2].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[1].repr);
		
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);
		
        setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);
		
		local x2,y2,z2 = getRotation(self.frontAxle.rotNode);
	
		setRotation(self.frontAxle.rotNode,x2 - math.rad(90),y2,z2 + math.rad(90));
	  end;
	  -------------PARAFANGHI - ANIMAZIONI RUOTE --------------
		if self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
			local x,y,z = getRotation(self.wheels[1].driveNode);
			local x2,y2,z2 = getRotation(self.wheels[1].repr);
			setRotation(self.animatedWheel[1].wheel, x,y,z);
			setRotation(self.animatedWheel[1].rotNode, x2,y2,z2);
	
			local x3,y3,z3 = getRotation(self.wheels[2].driveNode);
			local x4,y4,z4 = getRotation(self.wheels[2].repr);
			setRotation(self.animatedWheel[2].wheel, x3,y3,z3);
			setRotation(self.animatedWheel[2].rotNode, x4,y4,z4);
			
			end;
			---------- PARAFANGHI----------
		if self.animatedWheel[1].fenderAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil then
			local x, y, z = getRotation(self.animatedWheel[1].rotNode);
			local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);
	
			local fenderYRot = -y + math.rad(self.fenderAngle);
			local fenderY2Rot = -y2 + math.rad(-self.fenderAngle);
	
			if y > math.rad(self.fenderAngle) then
				setRotation(self.animatedWheel[1].fenderAttach, x, fenderYRot, z);
			else
				setRotation(self.animatedWheel[1].fenderAttach, x, 0, z);
			end;
			
			if y2 < math.rad(-self.fenderAngle) then
				setRotation(self.animatedWheel[2].fenderAttach, x2, fenderY2Rot, z2);
			else
				setRotation(self.animatedWheel[2].fenderAttach, x2, 0, z2);
			end;
	
			local x3,y3,z3 = getRotation(self.animatedWheel[1].fenderAttach);
		
	
			local x4,y4,z4 = getRotation(self.animatedWheel[2].fenderAttach);

		end;
		----- INCLINAZIONE RUOTE ---------
		if self.wheelCamberAngle ~= 0 and self.animatedWheel[1].rotNode ~= nil and self.animatedWheel[2].rotNode ~= nil then
			local x, y, z = getRotation(self.animatedWheel[1].rotNode);
			local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);
			
			local nodeZRot = -y * self.wheelCamberAngle;
			local nodeZ2Rot = -y2 * self.wheelCamberAngle;
			
			setRotation(self.animatedWheel[1].rotNode, x, y, nodeZRot);
			setRotation(self.animatedWheel[2].rotNode, x2, y2, nodeZ2Rot);
		end;
	
	end;	
end;


function Assale:onLeave()
end;

function Assale:draw()
	
end;
