﻿--
-- John Deere 1630
--
-- author  Mythos
-- date  24/02/2014
-- www.ARM-Team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

JD1630 = {};
--________________________________________________________________________________________________________________________________________________________
function JD1630.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:load(xmlFile)

	-- Functions
	self.OPER= SpecializationUtil.callSpecializationsFunction("OPER");
	
	-- Animations
	self.rdAnim = getXMLString(xmlFile, "vehicle.rdAnim#animationName");
	self.ldAnim = getXMLString(xmlFile, "vehicle.ldAnim#animationName");
	self.bwAnim = getXMLString(xmlFile, "vehicle.bwAnim#animationName");
	self.rwAnim = getXMLString(xmlFile, "vehicle.rwAnim#animationName");
	self.lwAnim = getXMLString(xmlFile, "vehicle.lwAnim#animationName");
	self.frontLoaderAnim = getXMLString(xmlFile, "vehicle.frontLoaderAnim#animationName");

	--Indexs
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));
	
	self.RW = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels.wheel(0)#repr"));
	self.LW = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wheels.wheel(1)#repr"));
	
	self.rightLink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightLink#index"));
	self.leftLink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftLink#index"));
	
	self.rightSBar = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightSBar#index"));
	self.leftSBar = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftSBar#index"));
	
	self.frontLoader = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLoader#index"));
	
	-- Booleans
	self.rd = false;
	self.ld = false;
	self.bw = false;
	self.rw = false;
	self.lw = false;
	self.fl = true;
	self.flAnim = false;
	self.engineRunTime = 0;
	self.updateJoint = false;
	
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:delete()

end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:mouseEvent(posX, posY, isDown, isUp, button)

end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:keyEvent(unicode, sym, modifier, isDown)

end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:update(dt)

	if self:getIsActiveForInput() and self:getIsActive() then
		
		if InputBinding.hasEvent(InputBinding.JD1630_RD) then
			self:OPER(1, not self.rd);
		end;
		
		if InputBinding.hasEvent(InputBinding.JD1630_LD) then
			self:OPER(2, not self.ld);
		end;
		
		if InputBinding.hasEvent(InputBinding.JD1630_BW) then
			self:OPER(3, not self.bw);
		end;
		
		if InputBinding.hasEvent(InputBinding.JD1630_RW) then
			self:OPER(4, not self.rw);
		end;
		
		if InputBinding.hasEvent(InputBinding.JD1630_LW) then
			self:OPER(5, not self.lw);
		end;
		
		if InputBinding.hasEvent(InputBinding.JD1630_FL) then
			self:OPER(6, not self.fl);
		end;
		
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:updateTick(dt)
	if self:getIsActive() or self.isHired then	
		
		if self.backHydraulic ~= nil then
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x+math.rad(14.235), y, z);
		end;
		
		local x, y, z = getRotation(self.RW);
		local x1, y1, z1 = getRotation(self.rightLink);
		setRotation(self.rightLink, x1, math.rad(180)+y, z1);
		setRotation(self.leftLink, x1, math.rad(180)+y, -z1);
		local x2, y2, z2 = getRotation(self.rightSBar);
		setRotation(self.rightSBar, x2, -(math.rad(90)+y), z2);
		local x2, y2, z2 = getRotation(self.leftSBar);
		setRotation(self.leftSBar, x2, -(math.rad(270)+y), z2);

		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("JD1630_FL"), InputBinding.JD1630_FL);
	g_currentMission:addExtraPrintText(g_i18n:getText("JD1630_ANIMS"));
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:OPER(mode, state, noEventSend)
	JD1630Event.sendEvent(self, mode, state, noEventSend);
	
	if mode==1 then
		if state then
			self:playAnimation(self.rdAnim, 1, nil, true);
			self.rd = true;
		else
			self:playAnimation(self.rdAnim, -1, nil, true);
			self.rd = false;
		end;
	elseif mode==2 then
		if state then
			self:playAnimation(self.ldAnim, 1, nil, true);
			self.ld = true;
		else
			self:playAnimation(self.ldAnim, -1, nil, true);
			self.ld = false;
		end;
	elseif mode==3 then
		if state then
			self:playAnimation(self.bwAnim, 1, nil, true);
			self.bw = true;
		else
			self:playAnimation(self.bwAnim, -1, nil, true);
			self.bw = false;
		end;
	elseif mode==4 then
		if state then
			self:playAnimation(self.rwAnim, 1, nil, true);
			self.rw = true;
		else
			self:playAnimation(self.rwAnim, -1, nil, true);
			self.rw = false;
		end;
	elseif mode==5 then
		if state then
			self:playAnimation(self.lwAnim, 1, nil, true);
			self.lw = true;
		else
			self:playAnimation(self.lwAnim, -1, nil, true);
			self.lw = false;
		end;
	elseif mode==6 then
		if state then
			setVisibility(self.frontLoader, true);
			self:playAnimation(self.frontLoaderAnim, -1, nil, true);
			self.fl = true;
			self.flAnim = false;
		else
			setVisibility(self.frontLoader, false);
			self:playAnimation(self.frontLoaderAnim, 1, nil, true);
			for i,v in pairs(self.attachedImplements) do
				if v.jointDescIndex == 4 then
					self:detachImplement(i, true);
				end;
			end;
			self.fl = false;
			self.flAnim = true;
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:readStream(streamId, connection)
	self.rd = streamReadBool(streamId);
	self.ld = streamReadBool(streamId);
	self.bw = streamReadBool(streamId);
	self.rw = streamReadBool(streamId);
	self.lw = streamReadBool(streamId);
	self.fl = streamReadBool(streamId);
	self.flAnim = streamReadBool(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:writeStream(streamId, connection)
    streamWriteBool(streamId, self.rd);
    streamWriteBool(streamId, self.ld);
	streamWriteBool(streamId, self.bw);
	streamWriteBool(streamId, self.rw);
	streamWriteBool(streamId, self.lw);
	streamWriteBool(streamId, self.fl);
	streamWriteBool(streamId, self.flAnim);
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.rd = Utils.getNoNil(getXMLBool(xmlFile, key.."#rd"),false);
		self.ld = Utils.getNoNil(getXMLBool(xmlFile, key.."#ld"),false);
		self.bw = Utils.getNoNil(getXMLBool(xmlFile, key.."#bw"),false);
		self.rw = Utils.getNoNil(getXMLBool(xmlFile, key.."#rw"),false);
		self.lw = Utils.getNoNil(getXMLBool(xmlFile, key.."#lw"),false);
		self.fl = Utils.getNoNil(getXMLBool(xmlFile, key.."#fl"),true);
		self.flAnim = Utils.getNoNil(getXMLBool(xmlFile, key.."#flAnim"),false);
		
		if self.rd then
			self:playAnimation(self.rdAnim, 100, nil, true);
		end;
		if self.ld then
			self:playAnimation(self.ldAnim, 100, nil, true);
		end;
		if self.bw then
			self:playAnimation(self.bwAnim, 100, nil, true);
		end;
		if self.rw then
			self:playAnimation(self.rwAnim, 100, nil, true);
		end;
		if self.lw then
			self:playAnimation(self.lwAnim, 100, nil, true);
		end;
		setVisibility(self.frontLoader, self.fl);
		if self.flAnim then
			self:playAnimation(self.frontLoaderAnim, 1, nil, true);
		end;

	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function JD1630:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'rd="'..tostring(self.rd)..
	'" ld="'..tostring(self.ld)..
	'" bw="'..tostring(self.bw)..
	'" rw="'..tostring(self.rw)..
	'" lw="'..tostring(self.lw)..
	'" fl="'..tostring(self.fl)..
	'" flAnim="'..tostring(self.flAnim)..'"';
	local nodes = nil;
	
	return attributes,nodes;
end;

--***********************************************************************************************************************************************************************************
--***********************************************************************************************************************************************************************************
JD1630Event = {};
JD1630Event_mt = Class(JD1630Event, Event);

InitEventClass(JD1630Event, "JD1630Event");

function JD1630Event:emptyNew()
    local self = Event:new(JD1630Event_mt);
    self.className="JD1630Event";
    return self;
end;

function JD1630Event:new(vehicle, mode, state)
    local self = JD1630Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function JD1630Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function JD1630Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function JD1630Event:run(connection)
	self.vehicle:OPER(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(JD1630Event:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function JD1630Event.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(JD1630Event:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(JD1630Event:new(vehicle, mode, state));
		end;
	end;
end;
