--
-- AloeCounterWeight
-- Specialization for  Aloe Counter-Weight
--
-- @author  Stefan Maurus	
-- @date  10/06/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

AloeCounterWeight = {};

function AloeCounterWeight.prerequisitesPresent(specializations)
    return true;
end;

function AloeCounterWeight:load(xmlFile)
	self.setCurrentWeight = SpecializationUtil.callSpecializationsFunction("setCurrentWeight"); 

	self.balls = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.balls#index"));	
	setVisibility(self.balls, false)	
	
	self.firstRound = true;
	
	self.currentWeightStep = 0;
	
	self.weights = {};
	self.weights.currentMass = 0;
	self.weights.basedMass = 0;
	
	self.weights.part1 = {};		
	self.weights.part1.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.weights.part1#index"));	
	self.weights.part1.mass = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.weights.part1#mass"), 1);
	
	self.weights.part2 = {};	
	self.weights.part2.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.weights.part2#index"));
	self.weights.part2.mass = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.weights.part2#mass"), 1);
	
	self.weights.part3 = {};		
	self.weights.part3.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.weights.part3#index"));	
	self.weights.part3.mass = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.weights.part3#mass"), 1);
	
	self.weights.part4 = {};		
	self.weights.part4.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.weights.part4#index"));	
	self.weights.part4.mass = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.weights.part4#mass"), 1);		
end;

function AloeCounterWeight:readStream(streamId, connection)
	self:setCurrentWeight(streamReadInt8(streamId), true); 
end;

function AloeCounterWeight:writeStream(streamId, connection) 
	streamWriteInt8(streamId, self.currentWeightStep); 
end;

function AloeCounterWeight:setCurrentWeight(int, noEventSend)	
	self.currentWeightStep = int;
	SetCurrentWeightEvent.sendEvent(self, int, noEventSend);
end;

function AloeCounterWeight:delete()
end;

function AloeCounterWeight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AloeCounterWeight:keyEvent(unicode, sym, modifier, isDown)
end;

function AloeCounterWeight:update(dt)
	if self:getIsActiveForInput() then		
		if InputBinding.hasEvent(InputBinding.ALOE_WEIGHT_LESS) and self.currentWeightStep > 0 then
			self:setCurrentWeight(self.currentWeightStep-1);		
		end;	
		if InputBinding.hasEvent(InputBinding.ALOE_WEIGHT_MORE) and self.currentWeightStep < 4 then
			self:setCurrentWeight(self.currentWeightStep+1);				
		end;		
	end;
end;

function AloeCounterWeight:updateTick(dt)
	if self.firstRound then
		self.weights.basedMass = getMass(self.components[1].node);
		self.firstRound = false;
	end;
	
	self.weights.currentMass = getMass(self.components[1].node);	

	if self.currentWeightStep == 0 then	
		setMass(self.components[1].node, self.weights.basedMass);	
		setVisibility(self.weights.part1.index, false);
		setVisibility(self.weights.part2.index, false);
		setVisibility(self.weights.part3.index, false);
		setVisibility(self.weights.part4.index, false);		
	elseif self.currentWeightStep == 1 then	
		setMass(self.components[1].node, self.weights.basedMass+self.weights.part1.mass);	
		setVisibility(self.weights.part1.index, true);
		setVisibility(self.weights.part2.index, false);
		setVisibility(self.weights.part3.index, false);
		setVisibility(self.weights.part4.index, false);			
	elseif self.currentWeightStep == 2 then	
		setMass(self.components[1].node, self.weights.basedMass+self.weights.part1.mass+self.weights.part2.mass);	
		setVisibility(self.weights.part1.index, true);
		setVisibility(self.weights.part2.index, true);
		setVisibility(self.weights.part3.index, false);
		setVisibility(self.weights.part4.index, false);			
	elseif self.currentWeightStep == 3 then
		setMass(self.components[1].node, self.weights.basedMass+self.weights.part1.mass+self.weights.part2.mass+self.weights.part3.mass);	
		setVisibility(self.weights.part1.index, true);
		setVisibility(self.weights.part2.index, true);
		setVisibility(self.weights.part3.index, true);
		setVisibility(self.weights.part4.index, false);			
	elseif self.currentWeightStep == 4 then	
		setMass(self.components[1].node, self.weights.basedMass+self.weights.part1.mass+self.weights.part2.mass+self.weights.part3.mass+self.weights.part4.mass);	
		setVisibility(self.weights.part1.index, true);
		setVisibility(self.weights.part2.index, true);
		setVisibility(self.weights.part3.index, true);
		setVisibility(self.weights.part4.index, true);			
	end;
end;

function AloeCounterWeight:onAttach()	
	setVisibility(self.balls, true)	
end;

function AloeCounterWeight:onDetach()	
	setVisibility(self.balls, false)	
end;

function AloeCounterWeight:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ALOE_WEIGHT_LESS"), InputBinding.ALOE_WEIGHT_LESS);
	g_currentMission:addHelpButtonText(g_i18n:getText("ALOE_WEIGHT_MORE"), InputBinding.ALOE_WEIGHT_MORE);	
	local currentMassKG = math.ceil(self.weights.currentMass*1000);
	local basedMassKG = math.ceil((self.weights.basedMass+self.weights.part1.mass+self.weights.part2.mass+self.weights.part3.mass+self.weights.part4.mass)*1000);
	g_currentMission:addExtraPrintText(string.format("%s: %d kg %s %d kg", g_i18n:getText("ALOE_WEIGHT_CURRENTMASS"), currentMassKG, g_i18n:getText("ALOE_WEIGHT_FROM"), basedMassKG));
end;

function AloeCounterWeight:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentWeight = getXMLInt(xmlFile, key .. "#currentWeight");
	if currentWeight ~= nil then
		self:setCurrentWeight(currentWeight);	
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;
 
function AloeCounterWeight:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentWeight="' .. self.currentWeightStep .. '" ';
	return attributes;
end;

SetCurrentWeightEvent = {};
SetCurrentWeightEvent_mt = Class(SetCurrentWeightEvent, Event);

InitEventClass(SetCurrentWeightEvent, "SetCurrentWeightEvent");

function SetCurrentWeightEvent:emptyNew()
    local self = Event:new(SetCurrentWeightEvent_mt);
    self.className="SetCurrentWeightEvent";
    return self;
end;

function SetCurrentWeightEvent:new(vehicle, currentWeightStep)
    local self = SetCurrentWeightEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentWeightStep = currentWeightStep;
    return self;
end;

function SetCurrentWeightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.currentWeightStep = streamReadInt8(streamId);
	self.vehicle:setCurrentWeight(self.currentWeightStep, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetCurrentWeightEvent:new(self.vehicle, self.currentWeightStep), nil, connection, self.vehicle);
    end;
end;

function SetCurrentWeightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.currentWeightStep);
end;


function SetCurrentWeightEvent.sendEvent(vehicle, currentWeightStep, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCurrentWeightEvent:new(vehicle, currentWeightStep), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCurrentWeightEvent:new(vehicle, currentWeightStep));
		end;
	end;
end;
