--
-- PDAExtensionForageStorage
--
-- @author  MX11
-- Version 1.0
-- @date 31.03.2013

print("Script loaded: PDAExtensionForageStorage V 1.0 Copyright by MX11");

PDAExtensionForageStorage = {};
PDAExtensionForageStorage.debug = false;


function PDAExtensionForageStorage:loadMap(name)
	if(PDAExtensionForageStorage.debug) then
		print("PDAExtensionForageStorage - DEBUG - PDAExtensionForageStorage:loadMap(name)");
	end;
	g_currentMission.missionPDA:addStatsPage(self.drawStatsPageAdditionalFarmSilos, self, nil, 2);		
end;

function PDAExtensionForageStorage:deleteMap()
	if(self.debug) then
		print("PDAExtensionForageStorage - DEBUG - PDAExtensionForageStorage:deleteMap()");
	end;
end;

function PDAExtensionForageStorage:delete()
	if(self.debug) then
		print("PDAExtensionForageStorage - DEBUG - PDAExtensionForageStorage:delete()");
	end;
end;

function PDAExtensionForageStorage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PDAExtensionForageStorage:keyEvent(unicode, sym, modifier, isDown)
end;

function PDAExtensionForageStorage:update(dt)
end;

function PDAExtensionForageStorage:draw()
end;

function PDAExtensionForageStorage:drawStatsPageAdditionalFarmSilos()
  local mission = g_currentMission
  local pda = g_currentMission.missionPDA;
  setTextBold(true)
  setTextColor(1, 1, 1, 1)
  setTextBold(false)
  local yOffset = 0.01
  local i = 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("FeedingTroughGrass_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_GRASS_WINDROW)+mission:getSiloAmount(Fillable.FILLTYPE_DRYGRASS_WINDROW))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("FeedingTroughSilage_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_SILAGE))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("FeedingTroughForage_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_FORAGE))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("FeedingTroughMisc_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_FORAGE_MIXING))))
  i = i + 1
  renderText(pda.pdaCol1, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, g_i18n:getText("Straw_storage") .. " [" .. g_i18n:getText("fluid_unit_short") .. "]")
  renderText(pda.pdaCol2, pda.pdaHeadRow - pda.pdaRowSpacing * i + yOffset, pda.pdaFontSize, string.format("%1.0f", g_i18n:getFluid(mission:getSiloAmount(Fillable.FILLTYPE_WHEAT_WINDROW)+mission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW))))
  i = i + 1

  setTextColor(1, 1, 1, 1)
end

addModEventListener(PDAExtensionForageStorage);
