-- Register fruits
function RegisterFruits()
local fruitList = {};

    -- Notes:
    -- "type" is not accurate. It were an attempt to group the fruits, so they may be easier selected at silos/sell-points.
    -- "fruitName" must be the same as in the FoliageSubLayers.
    -- table.insert(fruitList, {type="flower"  ,fruitName="sunflower"      ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=false ,minHarvestingGrowthState=4 ,pricePerLiter=0.60 ,literPerQm=3.1   ,seedUsagePerQm=0.50    ,seedPricePerLiter=0.6} );
	-- table.insert(fruitList, {type="flower"  ,fruitName="cotton"         ,needsSeeding=true  ,allowsSeeding=true ,hasStraw=true ,minHarvestingGrowthState=4 ,pricePerLiter=0.50 ,literPerQm=3.5   ,seedUsagePerQm=0.60    ,seedPricePerLiter=0.5} );
    --
    -- Can not seed or harvest! Only for transport!
    -- Make sure that 'allowsSeeding' is FALSE. If not, they would also show up in the sowing-machine!
    table.insert(fruitList, {type="none"    ,fruitName="manure"         ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    -- table.insert(fruitList, {type="none"    ,fruitName="liquidManure"   ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
	-- table.insert(fruitList, {type="none"    ,fruitName="milk"           ,needsSeeding=false ,allowsSeeding=false,hasStraw=false ,minHarvestingGrowthState=99,pricePerLiter=1.00 ,literPerQm=9.9 ,seedUsagePerQm=9.99    ,seedPricePerLiter=9.9} );
    --
    print(string.format("Registering %d extra fruits...", table.getn(fruitList)));
    for i=1, table.getn(fruitList) do
        local filename = "map01/".. fruitList[i].fruitName .."Hud.png";
        local hudFile = Utils.getFilename(filename, g_currentModDirectory);
        FruitUtil.registerFruitType(
             fruitList[i].fruitName                 -- string fruitName
            ,fruitList[i].needsSeeding              -- bool needsSeeding    (ARGH! I spent 3-4 days trying to find out why the new crop autogrows. Then I noticed an 's' were missing, so 'needSeeding' returned nil.)
            ,fruitList[i].allowsSeeding             -- bool allowsSeeding
            ,fruitList[i].hasStraw                  -- bool hasStraw
            ,fruitList[i].minHarvestingGrowthState  -- int minHarvestingGrowthState
            ,fruitList[i].pricePerLiter             -- float pricePerLiter
            ,fruitList[i].literPerQm                -- float literPerQm
            ,fruitList[i].seedUsagePerQm            -- float seedUsagePerQm
            ,fruitList[i].seedPricePerLiter         -- float seedPricePerLiter
            ,hudFile                                -- file hudFruitOverlayFilename
        );
    end;
end;
RegisterFruits();