--
-- IH 3588 2+2
-- Specialization class for IH 3588 2+2
--
-- @author  PeterJ - euroDZN
-- @date  2/10/2012
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

IH3588 = {};

function IH3588.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IH3588:load(xmlFile)
	
	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
    end;
	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
    end;
	local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
    if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
    end;
	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
    end;
	local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	end;
	local rotationPartNode6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
    if rotationPartNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
		self.lightsOn = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lights.light#decoration"));
    end;
	local rotationPartNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart7#index"));
    if rotationPartNode7 ~= nil then
        self.rotationPart7 = {};
        self.rotationPart7.node = rotationPartNode7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#minRot"));
        self.rotationPart7.minRot = {};
        self.rotationPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#maxRot"));
        self.rotationPart7.maxRot = {};
        self.rotationPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#rotTime"), 2)*1000;
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
    end;
	self.numberImplements = 0;
	self.hasNeedles = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.needles#hasNeedle"), false);
	local rotationPartFuel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.fuel#index"));
    if rotationPartFuel ~= nil then
        self.rotationFuel = {};
        self.rotationFuel.node = rotationPartFuel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.fuel#minRot"));
        self.rotationFuel.minRot = {};
        self.rotationFuel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.fuel#maxRot"));
        self.rotationFuel.maxRot = {};
        self.rotationFuel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationFuel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationFuel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	end;
	local rotationPartNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.battery#index"));
    if rotationPartNode9 ~= nil then
        self.rotationPart9 = {};
        self.rotationPart9.node = rotationPartNode9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.battery#minRot"));
        self.rotationPart9.minRot = {};
        self.rotationPart9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.battery#maxRot"));
        self.rotationPart9.maxRot = {};
        self.rotationPart9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.battery#rotTime"), 2)*1000;
    end;
	local rotationPartNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.temperature#index"));
    if rotationPartNode10 ~= nil then
        self.rotationPart10 = {};
        self.rotationPart10.node = rotationPartNode10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.temperature#minRot"));
        self.rotationPart10.minRot = {};
        self.rotationPart10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.temperature#maxRot"));
        self.rotationPart10.maxRot = {};
        self.rotationPart10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.temperature#rotTime"), 2)*1000;
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles.pressure#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.pressure#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.needles.pressure#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.needles.pressure#rotTime"), 2)*1000;
    end;
	
	self.bottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
	self.toplink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers#toplink"));
	self.toplink2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers#toplink2"));
	self.highHitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers#highHitch"));
 	setVisibility(self.toplink, false);
 	setVisibility(self.toplink2, true);
 	setVisibility(self.highHitch, false);
	
	self.armsAnimation = getXMLString(xmlFile, "vehicle.armLifters#animationName");
	self.operateArmsAnim = true;
	self.leverAnimation = getXMLString(xmlFile, "vehicle.gearLever#animationName");
	
	self.quickHitch = {};
	self.quickHitch.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers.quickHitch#index"));
	self.quickHitch.attacherJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers.quickHitch#attacherJoint"));
	self.quickHitch.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers.quickHitch#topReferenceNode"));
	self.quickHitch.detachJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attachers.quickHitch#detachJoint"));
	self.quickHitch.backup = {};
	self.quickHitch.backup.attacherJoint = nil;
    self.quickHitch.backup.topReferenceNode = nil;	

	
	self.drivingShaft = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.drivingShaft.driveShaft(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local driveShaft = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
		if driveShaft ~= nil then
			table.insert(self.drivingShaft, {node=driveShaft, speed=speed});
		end;
		i = i + 1;
	end;

	self.deactivateHose = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hydraulicHose#deactivate"), false);	
	if not self.deactivateHose then	
		local i=0;
		while true do
			local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;		
			local joint = self.attacherJoints[i+1];
			local hoseAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#hose"));
			if hoseAttacher ~= nil then
				joint.hydrahoseAttacher = hoseAttacher;
			end;
			i = i + 1;
		end;

		local attacherJointCount = i;
		i = 0;
		while true do
			local baseName = string.format("vehicle.trailerAttacherJoints.trailerAttacherJoint(%d)", i);
			local index = getXMLString(xmlFile, baseName.. "#index");
			if index == nil then
				break;
			end;
			
			local joint = self.attacherJoints[attacherJointCount + 1 + i];
			local hoseAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#hose"));
			if hoseAttacher ~= nil then
				joint.hydrahoseAttacher = hoseAttacher;
			end;
			i = i+1;
		end;
	end;
end;

function IH3588:delete()
end;

function IH3588:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IH3588:keyEvent(unicode, sym, modifier, isDown)
end;

function IH3588:update(dt)
	
	if self:getIsActive() then
		if self.rotationPart1 ~= nil then
			if self.selectedImplement ~= 0 then				
				for k,implement in pairs(self.attachedImplements) do
					local jointIndex = implement.jointDescIndex;
					if jointIndex == 1 and implement.object.allowsLowering then
						if implement.object:isLowered(false) then
							self.liftArmsLever = true;
						else
							self.liftArmsLever = false;
						end;
					else
						if self.trailerAttached then
							self.liftArmsLever = true;
						else
							self.liftArmsLever = false;
						end;							
					end;
				end;
			end;
			local x, y, z = getRotation(self.rotationPart1.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart1.maxRot, self.rotationPart1.minRot, 3, self.rotationPart1.rotTime, dt, not self.liftArmsLever);
			setRotation(self.rotationPart1.node, unpack(newRot));
		end;
		local maxhandthrottle = 1500;
		if self.rotationPart2 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart2.node);
			x = ((self.rotationPart2.maxRot[1] - self.rotationPart2.minRot[1]) / maxhandthrottle) * (self.motor.lastMotorRpm/1.5) + self.rotationPart2.minRot[1];
			y = ((self.rotationPart2.maxRot[2] - self.rotationPart2.minRot[2]) / maxhandthrottle) * (self.motor.lastMotorRpm/1.5) + self.rotationPart2.minRot[2];
			z = ((self.rotationPart2.maxRot[3] - self.rotationPart2.minRot[3]) / maxhandthrottle) * (self.motor.lastMotorRpm/1.5) + self.rotationPart2.minRot[3];
			setRotation(self.rotationPart2.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart2.node, self.rotationPart2.minRot[1], self.rotationPart2.minRot[2], self.rotationPart2.minRot[3]);
		end;
		if self.rotationPart3 ~= nil then
			local x, y, z = getRotation(self.rotationPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, self.brakeLightsVisibility);
			setRotation(self.rotationPart3.node, unpack(newRot));
		end;
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, self.brakeLightsVisibility);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart5 ~= nil and self.rotLeverPercent ~= nil then
			local maxRot = (self.rotationPart5.maxRot[1] - self.rotationPart5.minRot[1]), (self.rotationPart5.maxRot[2] - self.rotationPart5.minRot[2]), (self.rotationPart5.maxRot[3] - self.rotationPart5.minRot[3]);
			local newRot = maxRot*(self.rotLeverPercent/100);
			setRotation(self.rotationPart5.node, newRot);
		end;
		if self.rotationPart6 ~= nil then
			self.isLightsOn = getVisibility(self.lightsOn);
			local x, y, z = getRotation(self.rotationPart6.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.isLightsOn);
			setRotation(self.rotationPart6.node, unpack(newRot));
		end;
		if self.rotationPart7 ~= nil and self.trailerAttached then
			for k,implement in pairs(self.attachedImplements) do
				if implement.object.tipState == Trailer.TIPSTATE_OPENING or implement.object.tipState == Trailer.TIPSTATE_OPEN then
					self.operateHydraulicLever = true;
				else
					self.operateHydraulicLever = false;
				end;
			end;
			local x, y, z = getRotation(self.rotationPart7.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart7.maxRot, self.rotationPart7.minRot, 3, self.rotationPart7.rotTime, dt, not self.operateHydraulicLever);
			setRotation(self.rotationPart7.node, unpack(newRot));
		end;
		if self.rotationPart8 ~= nil then
			if self.numberImplements > 0 then
				for k,implement in pairs(self.attachedImplements) do
					if implement.object.isTurnedOn then
						self.operatePTOLever = true;
					else
						self.operatePTOLever = false;
					end;
				end;
			else
				self.operatePTOLever = false;		
			end;
			local x, y, z = getRotation(self.rotationPart8.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.operatePTOLever);
			setRotation(self.rotationPart8.node, unpack(newRot));
		end;
		if self.hasNeedles then
			if self.isMotorStarted then
				local x, y, z = getRotation(self.rotationFuel.node);
				x = (self.rotationFuel.maxRot[1] - self.rotationFuel.minRot[1]) * (self.fuelFillLevel/self.fuelCapacity);
				y = (self.rotationFuel.maxRot[2] - self.rotationFuel.minRot[2]) * (self.fuelFillLevel/self.fuelCapacity);
				z = (self.rotationFuel.maxRot[3] - self.rotationFuel.minRot[3]) * (self.fuelFillLevel/self.fuelCapacity);
				setRotation(self.rotationFuel.node, x, y, z);
				self.operateNeedles = true;
			else
				setRotation(self.rotationFuel.node, self.rotationFuel.minRot[1], self.rotationFuel.minRot[2], self.rotationFuel.minRot[3]);
				self.operateNeedles = false;
			end;
			local x, y, z = getRotation(self.rotationPart9.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart9.maxRot, self.rotationPart9.minRot, 3, self.rotationPart9.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart9.node, unpack(newRot));
			
			local x, y, z = getRotation(self.rotationPart10.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart10.maxRot, self.rotationPart10.minRot, 3, self.rotationPart10.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart10.node, unpack(newRot));
			
			local x, y, z = getRotation(self.rotationPart11.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart11.maxRot, self.rotationPart11.minRot, 3, self.rotationPart11.rotTime, dt, not self.operateNeedles);
			setRotation(self.rotationPart11.node, unpack(newRot));
		end;
		if self.leverAnimation ~= nil and self.playAnimation ~= nil then
			if self.movingDirection ~= 0 and self.lastMovedDistance > 0.015 then
				if self.movingDirection > 0 then
					if self.moveLever then
						self:playAnimation(self.leverAnimation, -1, nil, true);
						self.moveLever = false;
					end;
				else
					if not self.moveLever then
						self:playAnimation(self.leverAnimation, 1, nil, true);
						self.moveLever = true;
					end;
				end;
			end;
		end;
	end;
		if self.drivingShaft ~= nil then
			for _, driveShaft in pairs(self.drivingShaft) do
				local x,y,z = getRotation(self.wheels[1].driveNode);	
				setRotation(driveShaft.node, 0 ,0, x*driveShaft.speed);
			end;
		end;
end;

function IH3588:updateTick(dt)
end;

function IH3588:draw()
end;

function IH3588:onEnter()
end;

function IH3588:onLeave()
end;

function IH3588:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function IH3588:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	local attacherJoint = implement.object.attacherJoint;
	
	if jointType == Vehicle.JOINTTYPE_TRAILER or jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if self.armsAnimation ~= nil and self.playAnimation ~= nil and self.operateArmsAnim then
			self:playAnimation(self.armsAnimation, 1, nil, true);
			self.trailerAttached = true;
			setVisibility(self.quickHitch.index, false);
			setVisibility(self.toplink, true);
			setVisibility(self.toplink2, false);
			setVisibility(self.highHitch, true);	
		end;
	elseif jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			unlink(self.quickHitch.index);
			link(attacherJoint.node, self.quickHitch.index);
			setTranslation(self.quickHitch.index, 0, 0, 0);
			
			if attacherJoint.topReferenceNode ~= nil then
				local x,y,z = getWorldTranslation(attacherJoint.topReferenceNode);
				local x1,y1,z1 = getWorldTranslation(self.quickHitch.index);
				local xDir, yDir, zDir = worldDirectionToLocal(getParent(self.quickHitch.index), x-x1, y-y1, z-z1);
				setDirection(self.quickHitch.index, xDir, yDir, zDir, 0,1,-1);
				
				local x,y,z = getRotation(self.quickHitch.index);
				setRotation(self.quickHitch.index, x, math.rad(90), 0);
			else
				setRotation(self.quickHitch.index, math.rad(-90), math.rad(90), 0);
			end;
			
			self.quickHitch.backup.attacherJoint = attacherJoint.node;
			self.quickHitch.backup.topReferenceNode = attacherJoint.topReferenceNode;			
			attacherJoint.node = self.quickHitch.attacherJoint;
			attacherJoint.topReferenceNode = self.quickHitch.topReferenceNode;
			self.operateArmsAnim = false;
		end;
	end;
	self.numberImplements = self.numberImplements + 1;
end;

function IH3588:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	local jointType = implement.object.attacherJoint.jointType;
	local attacherJoint = implement.object.attacherJoint;
	self.liftArmsLever = false;
	
	if jointIndex == 1 then
		attacherJoint.node = self.quickHitch.backup.attacherJoint;
		attacherJoint.topReferenceNode = self.quickHitch.backup.topReferenceNode;
		
		unlink(self.quickHitch.index);
		link(self.quickHitch.detachJoint, self.quickHitch.index);
		setRotation(self.quickHitch.index, 0, 0, 0);
		self.operateArmsAnim = true;
	end;
	if jointType == Vehicle.JOINTTYPE_TRAILER or jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if self.armsAnimation ~= nil and self.playAnimation ~= nil and self.operateArmsAnim then
			self:playAnimation(self.armsAnimation, -1, nil, true);
			self.trailerAttached = false;
			setVisibility(self.quickHitch.index, true);
			setVisibility(self.toplink, false);
			setVisibility(self.toplink2, true);
			setVisibility(self.highHitch, false);
		end;
	end;
	self.numberImplements = self.numberImplements - 1;
end;
